/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.interpreter;

import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.interpreter.Interpreter;
import edu.berkeley.guir.lib.satin.interpreter.InterpreterImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.util.StringLib;

public abstract class InterpreterWrapper
extends InterpreterImpl {
    Interpreter intrp;

    public InterpreterWrapper() {
    }

    public InterpreterWrapper(Interpreter newintrp) {
        this.setInterpreter(newintrp);
    }

    public Interpreter setInterpreter(Interpreter newintrp) {
        this.intrp = newintrp;
        this.intrp.setAttachedGraphicalObject(this.getAttachedGraphicalObject());
        return newintrp;
    }

    public GraphicalObject setAttachedGraphicalObject(GraphicalObject newGob) {
        super.setAttachedGraphicalObject(newGob);
        this.intrp.setAttachedGraphicalObject(newGob);
        return newGob;
    }

    public Interpreter getInterpreter() {
        return this.intrp;
    }

    public boolean isEnabled() {
        return this.intrp.isEnabled();
    }

    public String toString() {
        StringBuffer strbuf = (StringBuffer)SatinConstants.poolStrbuf.getObject();
        strbuf.append(super.toString());
        strbuf.append("\nContained Interpreter:\n");
        strbuf.append(StringLib.indent(this.intrp.toString(), 3));
        String str = strbuf.toString();
        SatinConstants.poolStrbuf.releaseObject(strbuf);
        return str;
    }

    protected InterpreterWrapper clone(InterpreterWrapper iw) {
        super.clone(iw);
        iw.setAttachedGraphicalObject(this.getAttachedGraphicalObject());
        iw.setInterpreter((Interpreter)this.getInterpreter().clone());
        return iw;
    }
}

