/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.interpreter;

import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.event.BasicStrokeEventFilter;
import edu.berkeley.guir.lib.satin.event.NewStrokeEvent;
import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.event.StrokeEvent;
import edu.berkeley.guir.lib.satin.event.UpdateStrokeEvent;
import edu.berkeley.guir.lib.satin.interpreter.Interpreter;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import java.util.EventObject;

public abstract class InterpreterImpl
implements Interpreter {
    GraphicalObject gob;
    String strName;
    boolean flagEnabled = true;
    BasicStrokeEventFilter filter = new BasicStrokeEventFilter();

    public boolean isEnabled() {
        return this.flagEnabled;
    }

    public String getName() {
        return this.strName;
    }

    public void setEnabled(boolean flag) {
        this.flagEnabled = flag;
    }

    public String setName(String strName) {
        this.strName = strName;
        return strName;
    }

    public GraphicalObject setAttachedGraphicalObject(GraphicalObject newGob) {
        this.gob = newGob;
        return newGob;
    }

    public GraphicalObject getAttachedGraphicalObject() {
        return this.gob;
    }

    public void handleNewStroke(NewStrokeEvent evt) {
    }

    public void handleUpdateStroke(UpdateStrokeEvent evt) {
    }

    public void handleSingleStroke(SingleStrokeEvent evt) {
    }

    public boolean isConsumedAccepted() {
        return this.filter.isConsumedAccepted();
    }

    public boolean isLeftButtonAccepted() {
        return this.filter.isLeftButtonAccepted();
    }

    public boolean isMiddleButtonAccepted() {
        return this.filter.isMiddleButtonAccepted();
    }

    public boolean isRightButtonAccepted() {
        return this.filter.isRightButtonAccepted();
    }

    public void setAcceptConsumed(boolean flag) {
        this.filter.setAcceptConsumed(flag);
    }

    public void setAcceptLeftButton(boolean flag) {
        this.filter.setAcceptLeftButton(flag);
    }

    public void setAcceptMiddleButton(boolean flag) {
        this.filter.setAcceptMiddleButton(flag);
    }

    public void setAcceptRightButton(boolean flag) {
        this.filter.setAcceptRightButton(flag);
    }

    public boolean isEventAccepted(StrokeEvent evt) {
        return this.filter.isEventAccepted(evt);
    }

    public boolean isEventAccepted(EventObject evt) {
        return this.filter.isEventAccepted(evt);
    }

    public String toString() {
        StringBuffer strbuf = (StringBuffer)SatinConstants.poolStrbuf.getObject();
        strbuf.append("Interpreter Name: " + this.getName());
        strbuf.append("\nAttached GOb ID:  ");
        if (this.gob == null) {
            strbuf.append("Not attached");
        } else {
            strbuf.append(this.gob.getUniqueID());
        }
        strbuf.append("\nisEnabled:        " + this.flagEnabled);
        strbuf.append("\n" + this.filter.toString());
        String str = strbuf.toString();
        SatinConstants.poolStrbuf.releaseObject(strbuf);
        return str;
    }

    public abstract Object clone();

    protected InterpreterImpl clone(InterpreterImpl intrp) {
        intrp.gob = this.gob;
        intrp.strName = this.strName;
        intrp.flagEnabled = this.flagEnabled;
        intrp.filter = (BasicStrokeEventFilter)this.filter.clone();
        return intrp;
    }
}

