/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.interpreter;

import edu.berkeley.guir.lib.satin.interpreter.GestureCommandCallback;
import edu.berkeley.guir.lib.satin.interpreter.InterpreterImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectCollection;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import java.util.HashMap;
import java.util.Iterator;

public abstract class GestureCommandInterpreterImpl
extends InterpreterImpl {
    static final long serialVersionUID = -2123509812050370199L;
    HashMap singleCallbacks = new HashMap();
    HashMap groupCallbacks = new HashMap();
    GestureCommandCallback defaultCallback = null;

    public GestureCommandInterpreterImpl() {
        this.commonInitializations();
    }

    private void commonInitializations() {
    }

    protected GestureCommandCallback getGestureCommandCallback(String strGestureName) {
        GestureCommandCallback handle = null;
        handle = (GestureCommandCallback)this.singleCallbacks.get(strGestureName);
        if (handle != null) {
            return handle;
        }
        Iterator it = this.groupCallbacks.keySet().iterator();
        while (it.hasNext()) {
            String strKey = (String)it.next();
            if (!strGestureName.startsWith(strKey)) continue;
            handle = (GestureCommandCallback)this.groupCallbacks.get(strKey);
            return handle;
        }
        return this.defaultCallback;
    }

    protected void fireGestureCommandCallback(String strGestureName, TimedStroke stk, GraphicalObjectCollection gobcol) {
        GestureCommandCallback handle = this.getGestureCommandCallback(strGestureName);
        if (handle != null) {
            handle.onGestureCommand(stk, gobcol);
        }
    }

    public void registerCallback(String strGestureName, GestureCommandCallback handle) {
        this.singleCallbacks.put(strGestureName, handle);
    }

    public void unregisterCallback(String strGestureName) {
        this.singleCallbacks.remove(strGestureName);
    }

    public void registerGroupCallback(String strGestureName, GestureCommandCallback handle) {
        this.groupCallbacks.put(strGestureName, handle);
    }

    public void unregisterGroupCallback(String strGestureName) {
        this.groupCallbacks.remove(strGestureName);
    }

    public void registerDefaultCallback(GestureCommandCallback handle) {
        this.defaultCallback = handle;
    }

    public void unregisterDefaultCallback() {
        this.defaultCallback = null;
    }

    public GraphicalObject setAttachedGraphicalObject(GraphicalObject gob) {
        if (gob == null) {
            return null;
        }
        this.setName("Gesture Command Interpreter " + gob.getClass());
        return super.setAttachedGraphicalObject(gob);
    }

    protected GestureCommandInterpreterImpl clone(GestureCommandInterpreterImpl intrp) {
        super.clone(intrp);
        intrp.singleCallbacks = (HashMap)this.singleCallbacks.clone();
        intrp.groupCallbacks = (HashMap)this.groupCallbacks.clone();
        intrp.defaultCallback = this.defaultCallback;
        return intrp;
    }
}

