/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.interpreter;

import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.event.NewStrokeEvent;
import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.event.UpdateStrokeEvent;
import edu.berkeley.guir.lib.satin.interpreter.Interpreter;
import edu.berkeley.guir.lib.satin.interpreter.InterpreterImpl;
import edu.berkeley.guir.lib.satin.interpreter.MultiInterpreter;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.util.StringLib;
import java.util.Iterator;
import java.util.LinkedList;

public class DefaultMultiInterpreterImpl
extends InterpreterImpl
implements MultiInterpreter {
    static final long serialVersionUID = -8406563203951453814L;
    LinkedList listInterpreters = new LinkedList();

    public DefaultMultiInterpreterImpl() {
        this.commonInitializations();
    }

    private void commonInitializations() {
        this.setName("DefaultMultiInterpreterImpl");
    }

    public GraphicalObject setAttachedGraphicalObject(GraphicalObject gob) {
        super.setAttachedGraphicalObject(gob);
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Interpreter intrp = (Interpreter)it.next();
            intrp.setAttachedGraphicalObject(gob);
        }
        return gob;
    }

    public Interpreter add(Interpreter intrp) {
        this.listInterpreters.add(intrp);
        if (this.getAttachedGraphicalObject() != null) {
            intrp.setAttachedGraphicalObject(this.getAttachedGraphicalObject());
        }
        return intrp;
    }

    public Interpreter addToFront(Interpreter intrp) {
        this.listInterpreters.addFirst(intrp);
        if (this.getAttachedGraphicalObject() != null) {
            intrp.setAttachedGraphicalObject(this.getAttachedGraphicalObject());
        }
        return intrp;
    }

    public Interpreter remove(Interpreter intrp) {
        this.listInterpreters.remove(intrp);
        return intrp;
    }

    public Iterator iterator() {
        return this.listInterpreters.iterator();
    }

    public Interpreter get(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return (Interpreter)this.listInterpreters.get(index);
    }

    public boolean contains(Interpreter intrp) {
        return this.listInterpreters.contains(intrp);
    }

    public int size() {
        return this.listInterpreters.size();
    }

    public void clear() {
        this.listInterpreters.clear();
    }

    public void handleNewStroke(NewStrokeEvent evt) {
        if (!this.isEnabled()) {
            return;
        }
        Iterator it = this.iterator();
        while (it.hasNext() && !evt.isConsumed()) {
            Interpreter intrp = (Interpreter)it.next();
            if (!intrp.isEnabled() || !intrp.isEventAccepted(evt)) continue;
            intrp.handleNewStroke(evt);
        }
    }

    public void handleUpdateStroke(UpdateStrokeEvent evt) {
        if (!this.isEnabled()) {
            return;
        }
        Iterator it = this.iterator();
        while (it.hasNext() && !evt.isConsumed()) {
            Interpreter intrp = (Interpreter)it.next();
            if (!intrp.isEnabled() || !intrp.isEventAccepted(evt)) continue;
            intrp.handleUpdateStroke(evt);
        }
    }

    public void handleSingleStroke(SingleStrokeEvent evt) {
        if (!this.isEnabled()) {
            return;
        }
        Iterator it = this.iterator();
        while (it.hasNext() && !evt.isConsumed()) {
            Interpreter intrp = (Interpreter)it.next();
            if (!intrp.isEnabled() || !intrp.isEventAccepted(evt)) continue;
            intrp.handleSingleStroke(evt);
        }
    }

    public String toString() {
        StringBuffer strbuf = (StringBuffer)SatinConstants.poolStrbuf.getObject();
        Iterator it = this.iterator();
        strbuf.append(super.toString());
        strbuf.append("\nContained Interpreters:\n");
        while (it.hasNext()) {
            strbuf.append(StringLib.indent(it.next().toString(), 3));
            if (!it.hasNext()) continue;
            strbuf.append("\n\n");
        }
        String str = strbuf.toString();
        SatinConstants.poolStrbuf.releaseObject(strbuf);
        return str;
    }

    public Object clone() {
        return this.clone(new DefaultMultiInterpreterImpl());
    }

    protected DefaultMultiInterpreterImpl clone(DefaultMultiInterpreterImpl im) {
        super.clone(im);
        Iterator it = this.listInterpreters.iterator();
        while (it.hasNext()) {
            Interpreter intrpTmp = (Interpreter)it.next();
            im.listInterpreters.add(intrpTmp.clone());
        }
        im.setAttachedGraphicalObject(this.getAttachedGraphicalObject());
        return im;
    }
}

