/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.interpreter;

import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.interpreter.DefaultMultiInterpreterImpl;
import edu.berkeley.guir.lib.satin.interpreter.Interpreter;
import edu.berkeley.guir.lib.satin.interpreter.MultiInterpreter;
import java.util.Iterator;

public class DebugMultiInterpreterImpl
extends DefaultMultiInterpreterImpl
implements MultiInterpreter {
    static final long serialVersionUID = -8406563377581453814L;

    public DebugMultiInterpreterImpl() {
        this.commonInitializations();
    }

    private void commonInitializations() {
        this.setName("DebugMultiInterpreterImpl");
    }

    public void handleSingleStroke(SingleStrokeEvent evt) {
        if (!this.isEnabled()) {
            return;
        }
        System.out.println("-------------------------");
        System.out.println("---begin calling multi---");
        if (evt.isConsumed()) {
            System.out.println("evt is already consumed");
        }
        Iterator it = this.listInterpreters.iterator();
        while (it.hasNext() && !evt.isConsumed()) {
            Interpreter intrp = (Interpreter)it.next();
            if (intrp.isEnabled() && intrp.isEventAccepted(evt)) {
                System.out.println("---dispatching on " + intrp.getName() + " ---");
                intrp.handleSingleStroke(evt);
            }
            if (evt.isConsumed()) {
                System.out.println("---I think " + intrp.getName() + " consumed it---");
            }
            System.out.println("--- end calling multi ---");
            System.out.println("-------------------------");
            System.out.println();
        }
    }

    public Object clone() {
        return this.clone(new DebugMultiInterpreterImpl());
    }

    protected DebugMultiInterpreterImpl clone(DebugMultiInterpreterImpl im) {
        super.clone(im);
        return im;
    }
}

