/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.image;

import edu.berkeley.guir.lib.awt.image.ImageLib;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.Sheet;
import edu.berkeley.guir.lib.satin.graphics.SatinGraphics;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class SatinImageLib
implements SatinConstants {
    static boolean flagDrawStrokeStartPoint;
    public static boolean imageConvertingRender;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.satin.image.SatinImageLib");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        flagDrawStrokeStartPoint = false;
        imageConvertingRender = false;
    }

    public static void setDrawStrokeStartPoint(boolean flag) {
        flagDrawStrokeStartPoint = flag;
    }

    private SatinImageLib() {
    }

    public static BufferedImage toImage(GraphicalObject gob) {
        if (!$assertionsDisabled && gob == null) {
            throw new AssertionError((Object)"null parameter");
        }
        LinkedList<GraphicalObject> list = new LinkedList<GraphicalObject>();
        list.add(gob);
        return SatinImageLib.toImage(list);
    }

    public static void renderRegion(Graphics2D g2d, Dimension size, Sheet sheet, Rectangle2D region) {
        double sy;
        imageConvertingRender = true;
        double w = size.getWidth();
        double h = size.getHeight();
        SatinGraphics graphics = new SatinGraphics(g2d);
        double sx = w / region.getWidth();
        double s = sx < (sy = h / region.getHeight()) ? sx : sy;
        AffineTransform trans = AffineTransform.getScaleInstance(s, s);
        trans.concatenate(AffineTransform.getTranslateInstance(-region.getMinX(), -region.getMinY()));
        graphics.setBackground(Color.white);
        graphics.clearRect(0, 0, (int)w, (int)h);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        graphics.pushTransform(trans);
        sheet.render(graphics);
        graphics.popTransform();
        imageConvertingRender = false;
    }

    public static BufferedImage toBufferedImage(Dimension size, Sheet sheet, Rectangle2D region, boolean isBW) {
        imageConvertingRender = true;
        double w = size.getWidth();
        double h = size.getHeight();
        BufferedImage image = isBW ? new BufferedImage((int)w, (int)h, 13) : new BufferedImage((int)w, (int)h, 1);
        Graphics2D g2d = image.createGraphics();
        SatinGraphics graphics = new SatinGraphics(g2d);
        double sx = w / region.getWidth();
        double sy = h / region.getHeight();
        double s = sx < sy ? sx : sy;
        AffineTransform trans = AffineTransform.getScaleInstance(s, s);
        trans.concatenate(AffineTransform.getTranslateInstance(-region.getMinX(), -region.getMinY()));
        graphics.setBackground(Color.white);
        graphics.clearRect(0, 0, (int)w, (int)h);
        graphics.pushTransform(trans);
        sheet.render(graphics);
        graphics.popTransform();
        g2d.dispose();
        imageConvertingRender = false;
        return image;
    }

    public static BufferedImage toImage(List list) {
        GraphicalObject gob;
        imageConvertingRender = true;
        RectangularShape bounds = null;
        int hackWidth = 1;
        int hackHeight = 1;
        int maxLineWidth = 0;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            gob = (GraphicalObject)it.next();
            Rectangle2D boundsTmp = gob.getBounds2D(11);
            maxLineWidth = (int)Math.max((float)maxLineWidth, gob.getStyleRef().getLineWidth());
            if (bounds == null) {
                bounds = boundsTmp;
                continue;
            }
            Rectangle2D.union((Rectangle2D)bounds, boundsTmp, (Rectangle2D)bounds);
        }
        int width = (int)bounds.getWidth() + hackWidth + 2 * maxLineWidth;
        int height = (int)bounds.getHeight() + hackHeight + 2 * maxLineWidth;
        if (flagDrawStrokeStartPoint) {
            maxLineWidth += 5;
            width += 5;
            height += 5;
        }
        BufferedImage bimg = new BufferedImage(width, height, 2);
        SatinGraphics sg = new SatinGraphics(bimg.createGraphics());
        sg.clipRect(0, 0, width, height);
        it = list.iterator();
        while (it.hasNext()) {
            gob = (GraphicalObject)it.next();
            sg.pushStyle(gob.getStyleRef());
            sg.pushTransform(gob.getTransformRef());
            sg.pushTransform(AffineTransform.getTranslateInstance(-bounds.getX() + (double)maxLineWidth, -bounds.getY() + (double)maxLineWidth));
            gob.render(sg);
            if (flagDrawStrokeStartPoint && gob instanceof TimedStroke) {
                TimedStroke stk = (TimedStroke)gob;
                Point2D pt = stk.getStartPoint2D(10);
                sg.setColor(gob.getStyleRef().getDrawColor());
                sg.fillOval((int)pt.getX() - 5, (int)pt.getY() - 5, 10, 10);
            }
            sg.popTransform();
            sg.popTransform();
            sg.popStyle();
        }
        imageConvertingRender = false;
        return bimg;
    }

    public static void toGif(Image img, OutputStream out) throws IOException {
        ImageLib.toGif(img, out);
        out.close();
    }

    public static void toJPeg(Image img, OutputStream out) throws IOException {
        ImageLib.toJPeg(img, out);
        out.close();
    }

    public static void main(String[] argv) throws FileNotFoundException, IOException {
        FileOutputStream fout = new FileOutputStream("fos.gif");
        JFrame f = new JFrame();
        TimedStroke stk2 = new TimedStroke();
        stk2.addPoint(4, 12);
        stk2.addPoint(5, 40);
        stk2.addPoint(3, 68);
        stk2.addPoint(1, 88);
        stk2.addPoint(1, 104);
        stk2.addPoint(2, 115);
        stk2.addPoint(6, 117);
        stk2.addPoint(25, 114);
        stk2.addPoint(56, 106);
        stk2.addPoint(77, 101);
        stk2.addPoint(96, 99);
        stk2.addPoint(109, 99);
        stk2.addPoint(111, 89);
        stk2.addPoint(109, 67);
        stk2.addPoint(114, 43);
        stk2.addPoint(117, 26);
        stk2.addPoint(118, 16);
        stk2.addPoint(115, 6);
        stk2.addPoint(108, 1);
        stk2.addPoint(99, 0);
        stk2.addPoint(67, 4);
        stk2.addPoint(34, 11);
        stk2.addPoint(13, 17);
        stk2.addPoint(3, 20);
        stk2.addPoint(0, 23);
        ImageIcon icon = new ImageIcon(SatinImageLib.toImage(stk2));
        f.getContentPane().add(new JLabel(icon));
        f.setSize(500, 500);
        f.setVisible(true);
    }
}

