/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.graphics;

import java.awt.image.RGBImageFilter;

public final class TranslucentImageFilter
extends RGBImageFilter {
    double alphaPercent;

    public TranslucentImageFilter() {
        this(0.5);
    }

    public TranslucentImageFilter(double aPercent) throws IllegalArgumentException {
        this.setAlpha(aPercent);
        this.canFilterIndexColorModel = true;
    }

    public void setAlpha(double aPercent) {
        if (aPercent < 0.0 || aPercent > 1.0) {
            throw new IllegalArgumentException();
        }
        this.alphaPercent = aPercent;
        this.canFilterIndexColorModel = true;
    }

    public double getAlpha() {
        return this.alphaPercent;
    }

    public final int filterRGB(int x, int y, int rgb) {
        int a = rgb >> 24 & 0xFF;
        a = (int)((double)a * this.alphaPercent);
        return rgb & 0xFFFFFF | a << 24;
    }
}

