/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.graphics;

import edu.berkeley.guir.lib.collection.NonlockingStack;
import edu.berkeley.guir.lib.satin.graphics.GraphicsConstants;
import edu.berkeley.guir.lib.satin.graphics.GraphicsHighestQuality;
import edu.berkeley.guir.lib.satin.graphics.GraphicsLib;
import edu.berkeley.guir.lib.satin.graphics.GraphicsMediumQuality;
import edu.berkeley.guir.lib.satin.graphics.GraphicsXQuality;
import edu.berkeley.guir.lib.satin.graphics.TranslucentImageFilter;
import edu.berkeley.guir.lib.satin.objects.Style;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import java.util.StringTokenizer;

public class SatinGraphics
extends Graphics2D
implements GraphicsConstants {
    Graphics2D g;
    NonlockingStack stackStyle;
    NonlockingStack stackTransform;
    Style currentStyle;
    Color fillColor;
    Color drawColor;
    Color bkgrdColor;
    Color fontColor;
    Color tFillColor;
    Color tDrawColor;
    Color tFontColor;
    float transparency = 1.0f;
    TranslucentImageFilter tfilter;
    GraphicsXQuality delegate;
    GraphicsXQuality g_highest;
    GraphicsXQuality g_high;
    GraphicsXQuality g_medium;
    GraphicsXQuality g_low;
    GraphicsXQuality g_lowest;
    Font currentFont;
    String strCurrentFontName;
    Object mIssuer;
    AffineTransform txOldTransform;
    AffineTransform txDefaultTransform;
    NonlockingStack undo = new NonlockingStack();

    public SatinGraphics() {
        this.currentStyle = new Style();
        this.stackStyle = new NonlockingStack();
        this.stackTransform = new NonlockingStack();
        this.g_highest = new GraphicsHighestQuality();
        this.g_high = new GraphicsHighestQuality();
        this.g_medium = new GraphicsHighestQuality();
        this.g_low = new GraphicsHighestQuality();
        this.g_lowest = new GraphicsMediumQuality();
        this.delegate = this.g_highest;
        this.tfilter = new TranslucentImageFilter(1.0);
    }

    public SatinGraphics(Graphics2D newG) {
        this();
        this.setGraphics(newG);
    }

    public final void setRenderQuality(int value) {
        switch (value) {
            case 25: {
                this.delegate = this.g_highest;
                break;
            }
            case 26: {
                this.delegate = this.g_high;
                break;
            }
            case 27: {
                this.delegate = this.g_medium;
                break;
            }
            case 28: {
                this.delegate = this.g_low;
                break;
            }
            case 29: {
                this.delegate = this.g_lowest;
                break;
            }
            default: {
                throw new IllegalArgumentException("What the heck did you pass in?");
            }
        }
    }

    public final void setGraphics(Graphics2D newG) {
        this.setGraphics(newG, false);
    }

    public final void setGraphics(Graphics2D newG, boolean keepAntialiasHint) {
        this.g = newG;
        this.setGraphicsStyle(this.currentStyle);
        Object antialiasHint = newG.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        this.delegate.setGraphics(this.g);
        this.g.setRenderingHints(this.delegate.getHints());
        if (keepAntialiasHint) {
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasHint);
        }
        this.setDefaultTransform(this.g.getTransform());
        if (this.bkgrdColor == null) {
            this.bkgrdColor = this.g.getBackground();
        }
        this.currentFont = newG.getFont();
        this.strCurrentFontName = this.currentFont != null ? this.currentFont.getName() : "";
    }

    public final Graphics2D getGraphics() {
        return this.g;
    }

    public final void pushStyle(Style s) {
        this.stackStyle.push(this.currentStyle);
        this.currentStyle = s;
        this.setGraphicsStyle(this.currentStyle);
    }

    public final void popStyle() {
        this.currentStyle = (Style)this.stackStyle.pop();
        this.setGraphicsStyle(this.currentStyle);
    }

    private final void setGraphicsStyle(Style s) {
        this.setStroke(s.getDrawStroke());
        this.setFont(s.getDrawFont());
        this.fillColor = s.getFillColor();
        this.drawColor = s.getDrawColor();
        this.fontColor = s.getFontColor();
        this.tFillColor = GraphicsLib.makeTransparent(this.fillColor, this.transparency);
        this.tDrawColor = GraphicsLib.makeTransparent(this.drawColor, this.transparency);
        this.tFontColor = GraphicsLib.makeTransparent(this.fontColor, this.transparency);
    }

    public final Style getStyle() {
        return (Style)this.currentStyle.clone();
    }

    public final void setTransparency(float val) {
        if (val < 0.0f || val > 1.0f) {
            throw new IllegalArgumentException("Invalid value for transparency");
        }
        this.transparency = val;
        this.tfilter.setAlpha(val);
        this.tFillColor = GraphicsLib.makeTransparent(this.fillColor, this.transparency);
        this.tDrawColor = GraphicsLib.makeTransparent(this.drawColor, this.transparency);
        this.tFontColor = GraphicsLib.makeTransparent(this.fontColor, this.transparency);
    }

    public final float getTransparency() {
        return this.transparency;
    }

    public final void pushOrigin(int x, int y) {
        AffineTransform tx = new AffineTransform();
        tx.translate(x, y);
        this.pushTransform(tx);
    }

    public final void pushOrigin(Point pt) {
        this.pushOrigin(pt.x, pt.y);
    }

    public final void popOrigin() {
        this.popTransform();
    }

    public final Point getOrigin() {
        return this.getTranslation(this.getTransform());
    }

    private final Point getTranslation(AffineTransform tx) {
        return new Point((int)tx.getTranslateX(), (int)tx.getTranslateY());
    }

    public final void clearAllTransforms() {
        this.stackTransform.clear();
        this.g.setTransform(this.g.getDeviceConfiguration().getDefaultTransform());
    }

    public final void setDefaultTransform(AffineTransform tx) {
        this.txDefaultTransform = tx;
    }

    public final void ignoreTransforms() {
        this.txOldTransform = this.g.getTransform();
        this.g.setTransform(this.txDefaultTransform);
    }

    public final void dontIgnoreTransforms() {
        this.g.setTransform(this.txOldTransform);
    }

    public final void pushTransform(AffineTransform tx) {
        this.stackTransform.push(this.g.getTransform());
        this.g.transform(tx);
    }

    public final void popTransform() {
        AffineTransform tx = (AffineTransform)this.stackTransform.pop();
        this.g.setTransform(tx);
    }

    public static Point calculateNewPosition(Shape shape, int pos) {
        Point pt;
        Rectangle rect = shape.getBounds();
        int x = rect.x;
        int y = rect.y;
        int w = rect.width;
        int h = rect.height;
        switch (pos) {
            case 80: {
                pt = new Point(x, y);
                break;
            }
            case 81: {
                pt = new Point(x - w / 2, y);
                break;
            }
            case 82: {
                pt = new Point(x - w, y);
                break;
            }
            case 83: {
                pt = new Point(x, y - h / 2);
                break;
            }
            case 84: {
                pt = new Point(x - w / 2, y - h / 2);
                break;
            }
            case 85: {
                pt = new Point(x - w, y - h / 2);
                break;
            }
            case 86: {
                pt = new Point(x, y - h);
                break;
            }
            case 87: {
                pt = new Point(x - w / 2, y - h);
                break;
            }
            case 88: {
                pt = new Point(x - w, y - h);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown position value " + pos);
            }
        }
        return pt;
    }

    public static Point calculateTranslation(Shape shape, int x, int y, int pos) {
        Point newLoc = SatinGraphics.calculateNewPosition(shape, pos);
        Rectangle oldBounds = shape.getBounds();
        return new Point(newLoc.x - oldBounds.x, newLoc.y - oldBounds.y);
    }

    public void drawString(String str, int x, int y, int pos) {
        FontMetrics fmetric = this.getFontMetrics();
        Rectangle rect = GraphicsLib.calculateBoundingBox(str, this.getFont(), x, y, pos);
        rect.y += fmetric.getHeight();
        this.drawString(str, rect.x, rect.y);
    }

    public void drawRect(Rectangle rect) {
        this.drawRect(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawRect(Rectangle rect, int pos) {
        this.drawRect(rect.x, rect.y, rect.width, rect.height, pos);
    }

    public void drawRect(int x, int y, int width, int height, int pos) {
        Rectangle rect = new Rectangle(x, y, width, height);
        Point pt = SatinGraphics.calculateNewPosition(rect, pos);
        this.drawRect(pt.x, pt.y, rect.width, rect.height);
    }

    public void fillRect(Rectangle rect, int pos) {
        this.fillRect(rect.x, rect.y, rect.width, rect.height, pos);
    }

    public void fillRect(int x, int y, int width, int height, int pos) {
        Rectangle rect = new Rectangle(x, y, width, height);
        Point pt = SatinGraphics.calculateNewPosition(rect, pos);
        this.fillRect(pt.x, pt.y, rect.width, rect.height);
    }

    public final void dispose() {
        this.g.dispose();
    }

    public final void finalize() {
        this.g.finalize();
    }

    public boolean hitClip(int x, int y, int width, int height) {
        return this.g.hitClip(x, y, width, height);
    }

    public Graphics create() {
        return this.g.create();
    }

    public Graphics create(int x, int y, int width, int height) {
        return this.g.create(x, y, width, height);
    }

    public final void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.g.copyArea(x, y, width, height, dx, dy);
    }

    public final void addRenderingHints(Map hints) {
        this.g.addRenderingHints(hints);
    }

    public final void setColor(Color c) {
        Color cc;
        this.tFillColor = cc = GraphicsLib.makeTransparent(c, this.transparency);
        this.tDrawColor = cc;
        this.tFontColor = cc;
        this.g.setColor(cc);
    }

    public final void setFont(Font font) {
        if (font == this.currentFont) {
            return;
        }
        String strNewFontName = null;
        if (this.currentFont != null && (strNewFontName = font.getFontName()).equals(this.strCurrentFontName)) {
            return;
        }
        if (strNewFontName == null) {
            strNewFontName = font.getFontName();
        }
        this.currentFont = font;
        this.strCurrentFontName = strNewFontName;
        this.g.setFont(font);
    }

    public final void setPaintMode() {
        this.g.setPaintMode();
    }

    public final void setXORMode(Color c1) {
        this.g.setXORMode(c1);
    }

    public final void setClip(int x, int y, int width, int height) {
        this.g.setClip(x, y, width, height);
    }

    public final void setClip(Shape clip) {
        this.g.setClip(clip);
    }

    public final void clipRect(int x, int y, int width, int height) {
        this.g.clipRect(x, y, width, height);
    }

    public Color getColor() {
        return this.g.getColor();
    }

    public Font getFont() {
        return this.g.getFont();
    }

    public FontMetrics getFontMetrics() {
        return this.g.getFontMetrics();
    }

    public FontMetrics getFontMetrics(Font f) {
        return this.g.getFontMetrics(f);
    }

    public Rectangle getClipBounds() {
        return this.g.getClipBounds();
    }

    public Shape getClip() {
        return this.g.getClip();
    }

    public Rectangle getClipRect() {
        return this.g.getClipRect();
    }

    public Rectangle getClipBounds(Rectangle r) {
        return this.g.getClipBounds(r);
    }

    public final void drawLine(int x1, int y1, int x2, int y2) {
        this.g.setColor(this.tDrawColor);
        this.delegate.drawLine(x1, y1, x2, y2);
    }

    public final void fillRect(int x, int y, int width, int height) {
        this.g.setColor(this.tFillColor);
        this.delegate.fillRect(x, y, width, height);
    }

    public final void drawRect(int x, int y, int width, int height) {
        this.g.setColor(this.tDrawColor);
        this.delegate.drawRect(x, y, width, height);
    }

    public final void clearRect(int x, int y, int width, int height) {
        this.delegate.clearRect(x, y, width, height);
    }

    public final void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.g.setColor(this.tDrawColor);
        this.delegate.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public final void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.g.setColor(this.tFillColor);
        this.delegate.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public final void drawOval(int x, int y, int width, int height) {
        this.g.setColor(this.tDrawColor);
        this.delegate.drawOval(x, y, width, height);
    }

    public final void fillOval(int x, int y, int width, int height) {
        this.g.setColor(this.tFillColor);
        this.delegate.fillOval(x, y, width, height);
    }

    public final void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.g.setColor(this.tDrawColor);
        this.delegate.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    public final void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.g.setColor(this.tFillColor);
        this.delegate.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    public final void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.g.setColor(this.tDrawColor);
        this.delegate.drawPolyline(xPoints, yPoints, nPoints);
    }

    public final void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.g.setColor(this.tDrawColor);
        this.delegate.drawPolygon(xPoints, yPoints, nPoints);
    }

    public final void drawPolygon(Polygon p) {
        this.g.setColor(this.tDrawColor);
        this.delegate.drawPolygon(p);
    }

    public final void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.g.setColor(this.tFillColor);
        this.delegate.fillPolygon(xPoints, yPoints, nPoints);
    }

    public final void fillPolygon(Polygon p) {
        this.g.setColor(this.tFillColor);
        this.delegate.fillPolygon(p);
    }

    public final void drawString(String str, int x, int y) {
        this.g.setColor(this.tFontColor);
        this.delegate.drawString(str, x, y);
    }

    public final void drawChars(char[] data, int offset, int length, int x, int y) {
        this.g.setColor(this.tFontColor);
        this.delegate.drawChars(data, offset, length, x, y);
    }

    public final void drawBytes(byte[] data, int offset, int length, int x, int y) {
        this.g.setColor(this.tDrawColor);
        this.delegate.drawBytes(data, offset, length, x, y);
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        this.g.setColor(this.tDrawColor);
        return this.delegate.drawImage(img, x, y, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        this.g.setColor(this.tDrawColor);
        return this.delegate.drawImage(img, x, y, width, height, observer);
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        this.g.setColor(this.tDrawColor);
        return this.delegate.drawImage(img, x, y, bgcolor, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        this.g.setColor(this.tDrawColor);
        return this.delegate.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        this.g.setColor(this.tDrawColor);
        return this.delegate.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        this.g.setColor(this.tDrawColor);
        return this.delegate.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    public FontRenderContext getFontRenderContext() {
        return this.g.getFontRenderContext();
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return this.g.hit(rect, s, onStroke);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.g.getDeviceConfiguration();
    }

    public final void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.g.setRenderingHint(hintKey, hintValue);
    }

    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.g.getRenderingHint(hintKey);
    }

    public final void setRenderingHints(Map hints) {
        this.g.setRenderingHints(hints);
    }

    public RenderingHints getRenderingHints() {
        return this.g.getRenderingHints();
    }

    public Color getBackground() {
        return this.bkgrdColor;
    }

    public Stroke getStroke() {
        return this.g.getStroke();
    }

    public AffineTransform getTransform() {
        return this.g.getTransform();
    }

    public Paint getPaint() {
        return this.g.getPaint();
    }

    public Composite getComposite() {
        return this.g.getComposite();
    }

    public final void setStroke(Stroke s) {
        this.g.setStroke(s);
    }

    public final void setTransform(AffineTransform Tx) {
        this.g.setTransform(Tx);
    }

    public final void translate(int x, int y) {
        this.g.translate(x, y);
    }

    public final void translate(double tx, double ty) {
        this.g.translate(tx, ty);
    }

    public final void rotate(double theta) {
        this.g.rotate(theta);
    }

    public final void rotate(double theta, double x, double y) {
        this.g.rotate(theta, x, y);
    }

    public final void scale(double sx, double sy) {
        this.g.scale(sx, sy);
    }

    public final void shear(double shx, double shy) {
        this.g.shear(shx, shy);
    }

    public final void transform(AffineTransform Tx) {
        this.g.transform(Tx);
    }

    public final void clip(Shape s) {
        this.g.clip(s);
    }

    public final void setComposite(Composite comp) {
        this.g.setComposite(comp);
    }

    public final void setPaint(Paint paint) {
        this.g.setPaint(paint);
    }

    public final void setBackground(Color color) {
        this.bkgrdColor = color;
        if (this.g != null) {
            this.g.setBackground(color);
        }
    }

    public final void draw(GeneralPath thePath) {
        this.g.setColor(this.tDrawColor);
        this.g.draw(thePath);
    }

    public final void draw(Shape s) {
        this.g.setColor(this.tDrawColor);
        this.delegate.draw(s);
    }

    public final void draw3DRect(int x, int y, int width, int height, boolean raised) {
        this.g.setColor(this.tDrawColor);
        this.delegate.draw3DRect(x, y, width, height, raised);
    }

    public final void drawGlyphVector(GlyphVector gv, float x, float y) {
        this.g.setColor(this.tDrawColor);
        this.delegate.drawGlyphVector(gv, x, y);
    }

    public final void fill3DRect(int x, int y, int width, int height, boolean raised) {
        this.g.setColor(this.tFillColor);
        this.delegate.fill3DRect(x, y, width, height, raised);
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        this.g.setColor(this.tDrawColor);
        return this.delegate.drawImage(img, xform, obs);
    }

    public final void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.g.setColor(this.tDrawColor);
        this.delegate.drawImage(img, op, x, y);
    }

    public final void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.g.setColor(this.tDrawColor);
        this.delegate.drawRenderedImage(img, xform);
    }

    public final void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.g.setColor(this.tDrawColor);
        this.delegate.drawRenderableImage(img, xform);
    }

    public final void drawString(String s, float x, float y) {
        this.g.setColor(this.tFontColor);
        this.delegate.drawString(s, x, y);
    }

    public final void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.g.setColor(this.tFontColor);
        this.delegate.drawString(iterator, x, y);
    }

    public final void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.g.setColor(this.tFontColor);
        this.delegate.drawString(iterator, x, y);
    }

    public void renderString(String str, int xx, int yy) {
        FontMetrics fmetric = this.getFontMetrics(this.getFont());
        float height = (float)fmetric.getHeight() * 0.75f;
        StringTokenizer strtok = new StringTokenizer(str, "\r\n\t");
        int offset = 0;
        yy -= (int)((float)(strtok.countTokens() - 1) / 2.0f * height);
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            float width = fmetric.stringWidth(token);
            this.drawString(token, (int)((double)xx - 0.5 * (double)width), (int)((double)yy + 0.8 * (double)height) + offset);
            offset = (int)((float)offset + height);
        }
    }

    public void renderStackedString(String str, int xx, int yy) {
        FontMetrics fmetric = this.getFontMetrics(this.getFont());
        float height = (float)fmetric.getHeight() * 0.75f;
        StringTokenizer strtok = new StringTokenizer(str, "\r\n\t");
        int offset = 0;
        yy -= (int)((float)str.length() / 2.0f * height);
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            float width = fmetric.stringWidth(token);
            int i = 0;
            while (i < token.length()) {
                char[] hold = new char[]{'a'};
                hold[0] = token.charAt(i);
                String holder = new String(hold);
                this.renderString(holder, xx, (int)((double)yy + 0.8 * (double)height + (double)offset));
                offset = (int)((float)offset + height);
                ++i;
            }
        }
    }

    public final void fill(Shape s) {
        this.g.setColor(this.tFillColor);
        this.delegate.fill(s);
    }

    public void setIssuer(Object obj) {
        this.mIssuer = obj;
    }

    public Object getIssuer() {
        return this.mIssuer;
    }

    public String toString() {
        return String.valueOf(this.g.toString()) + "\n" + this.stackTransform.toString();
    }
}

