/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.graphics;

import edu.berkeley.guir.lib.collection.ObjectPool;
import edu.berkeley.guir.lib.debugging.Debug;
import edu.berkeley.guir.lib.satin.graphics.SatinGraphics;
import edu.berkeley.guir.lib.satin.objects.Style;
import edu.berkeley.guir.lib.satin.view.View;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;

public class RepaintQueue {
    private static final int POOLSIZE = 500;
    ArrayList queue = new ArrayList(500);
    PaintObjectPool pool = new PaintObjectPool(500);

    public void enqueue(View v, Style s, AffineTransform tx) {
        try {
            PaintObject pobj = (PaintObject)this.pool.getObject();
            pobj.v = v;
            pobj.s = s;
            pobj.tx = tx;
            this.queue.add(pobj);
        }
        catch (Exception e) {
            Debug.println("Failed to enqueue, out of objects in ObjectPool");
        }
    }

    private void clear() {
        this.pool.reset();
        this.queue.clear();
    }

    public void blit(SatinGraphics g) {
        int i = 0;
        while (i < this.queue.size()) {
            PaintObject p = (PaintObject)this.queue.get(i);
            p.render(g);
            ++i;
        }
        this.clear();
    }

    public void blit(SatinGraphics g, long ms) {
        PaintObject p;
        long endTime = System.currentTimeMillis() + ms;
        boolean flagBlitRest = false;
        int i = 0;
        while (i < this.queue.size()) {
            p = (PaintObject)this.queue.get(i);
            p.render(g);
            if (System.currentTimeMillis() > endTime) {
                flagBlitRest = true;
                break;
            }
            ++i;
        }
        if (flagBlitRest) {
            g.setRenderQuality(29);
            while (i < this.queue.size()) {
                p = (PaintObject)this.queue.get(i);
                p.render(g);
                ++i;
            }
        }
        this.clear();
    }

    final class PaintObjectPool
    extends ObjectPool {
        public PaintObjectPool(int size) {
            super(size);
        }

        protected Object createObject() {
            return new PaintObject();
        }
    }

    final class PaintObject {
        Style s;
        AffineTransform tx;
        View v;

        public PaintObject() {
        }

        public PaintObject(View v, Style s, AffineTransform tx) {
            this.v = v;
            this.s = s;
            this.tx = tx;
        }

        public final void render(SatinGraphics g) {
            g.pushStyle(this.s);
            g.pushTransform(this.tx);
            this.v.render(g);
            g.popTransform();
            g.popStyle();
        }
    }
}

