/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.graphics;

import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.berkeley.guir.lib.satin.graphics.GraphicsLowQuality;
import edu.berkeley.guir.lib.satin.graphics.GraphicsXQuality;
import java.awt.Color;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;

public class GraphicsLowestQuality
extends GraphicsLowQuality {
    public GraphicsLowestQuality() {
        this.hints = new GraphicsXQuality.HintsHashMap();
        this.hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        this.hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        this.hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        this.hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        this.hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
    }

    public void fillRect(int x, int y, int width, int height) {
        this.g.drawRect(x, y, width, height);
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.g.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public void fillOval(int x, int y, int width, int height) {
        this.g.drawOval(x, y, width, height);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.g.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.drawPolygon(new Polygon(xPoints, yPoints, nPoints));
    }

    public void fillPolygon(Polygon p) {
        this.g.draw(p.getBounds());
    }

    public void drawString(String str, int x, int y) {
        this.g.drawString(str, x, y);
    }

    public void drawChars(char[] data, int offset, int length, int x, int y) {
        this.g.drawChars(data, offset, length, x, y);
    }

    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        this.g.drawBytes(data, offset, length, x, y);
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        this.g.drawRect(x, y, img.getWidth(null), img.getHeight(null));
        return true;
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        this.g.drawRect(x, y, width, height);
        return true;
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        this.g.drawRect(x, y, img.getWidth(null), img.getHeight(null));
        return true;
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        this.g.drawRect(x, y, width, height);
        return true;
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        this.g.drawRect(dx1, dy1, dx2 - dx1, dy2 - dy1);
        return true;
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        this.g.drawRect(dx1, dy1, dx2 - dx1, dy2 - dy1);
        return true;
    }

    public void draw(Shape s) {
        this.g.draw(s);
    }

    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        this.g.draw3DRect(x, y, width, height, raised);
    }

    public void drawGlyphVector(GlyphVector gv, float x, float y) {
        this.g.drawGlyphVector(gv, x, y);
    }

    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        this.g.draw3DRect(x, y, width, height, raised);
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, img.getWidth(null), img.getHeight(null));
        GeomLib.transformRectangle(xform, rect, rect);
        this.g.draw(rect);
        return true;
    }

    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.g.drawRect(x, y, img.getWidth(), img.getHeight());
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, img.getWidth(), img.getHeight());
        GeomLib.transformRectangle(xform, rect, rect);
        this.g.draw(rect);
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.g.drawRenderableImage(img, xform);
    }

    public void drawString(String s, float x, float y) {
        this.g.drawString(s, x, y);
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.g.drawString(iterator, x, y);
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.g.drawString(iterator, x, y);
    }

    public void fill(Shape s) {
        this.g.draw(s);
    }
}

