/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.graphics;

import edu.berkeley.guir.lib.awt.geom.AffineTransformLib;
import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.berkeley.guir.lib.satin.graphics.GraphicsMediumQuality;
import edu.berkeley.guir.lib.satin.graphics.GraphicsXQuality;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;

public class GraphicsLowQuality
extends GraphicsMediumQuality {
    public GraphicsLowQuality() {
        this.hints = new GraphicsXQuality.HintsHashMap();
        this.hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        this.hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        this.hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        this.hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        this.hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
    }

    public void draw(Shape s) {
        if (s instanceof Polygon2D) {
            Polygon2D p = (Polygon2D)s;
            if (AffineTransformLib.getScaleFactor(this.getTransform()) < 0.1) {
                this.drawLine((int)p.xpoints[0], (int)p.ypoints[0], (int)p.xpoints[p.npoints - 1], (int)p.ypoints[p.npoints - 1]);
                return;
            }
            s = p.simplify();
        }
        super.draw(s);
    }

    public void fill(Shape s) {
        if (s instanceof Polygon2D) {
            s = ((Polygon2D)s).simplify();
        }
        super.fill(s);
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        Polygon p = GeomLib.simplify(xPoints, yPoints, nPoints);
        this.g.drawPolyline(p.xpoints, p.ypoints, p.npoints);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Polygon p = GeomLib.simplify(xPoints, yPoints, nPoints);
        this.g.drawPolygon(p.xpoints, p.ypoints, p.npoints);
    }

    public void drawPolygon(Polygon p) {
        this.g.drawPolygon(GeomLib.simplify(p.xpoints, p.ypoints, p.npoints));
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Polygon p = GeomLib.simplify(xPoints, yPoints, nPoints);
        this.g.fillPolygon(p.xpoints, p.ypoints, p.npoints);
    }

    public void fillPolygon(Polygon p) {
        this.g.fillPolygon(GeomLib.simplify(p.xpoints, p.ypoints, p.npoints));
    }
}

