/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.graphics;

import edu.berkeley.guir.lib.satin.graphics.GraphicsConstants;
import edu.berkeley.guir.lib.util.StringLib;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.util.StringTokenizer;

public final class GraphicsLib
implements GraphicsConstants {
    private GraphicsLib() {
    }

    public static Point calculateNewPosition(Shape shape, int pos) {
        Point pt;
        Rectangle rect = shape.getBounds();
        int x = rect.x;
        int y = rect.y;
        int w = rect.width;
        int h = rect.height;
        switch (pos) {
            case 80: {
                pt = new Point(x, y);
                break;
            }
            case 81: {
                pt = new Point(x - w / 2, y);
                break;
            }
            case 82: {
                pt = new Point(x - w, y);
                break;
            }
            case 83: {
                pt = new Point(x, y - h / 2);
                break;
            }
            case 84: {
                pt = new Point(x - w / 2, y - h / 2);
                break;
            }
            case 85: {
                pt = new Point(x - w, y - h / 2);
                break;
            }
            case 86: {
                pt = new Point(x, y - h);
                break;
            }
            case 87: {
                pt = new Point(x - w / 2, y - h);
                break;
            }
            case 88: {
                pt = new Point(x - w, y - h);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown position value " + pos);
            }
        }
        return pt;
    }

    public static Point calculateTranslation(Shape shape, int x, int y, int pos) {
        Point newLoc = GraphicsLib.calculateNewPosition(shape, pos);
        Rectangle oldBounds = shape.getBounds();
        return new Point(newLoc.x - oldBounds.x, newLoc.y - oldBounds.y);
    }

    public static int calculateTotalWidth(String str, Font font) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        FontMetrics fmetric = tk.getFontMetrics(font);
        return GraphicsLib.calculateTotalWidth(str, fmetric);
    }

    public static int calculateTotalWidth(String str, FontMetrics fmetric) {
        int width = 0;
        int widthTmp = 0;
        StringTokenizer strtok = new StringTokenizer(str);
        while (strtok.hasMoreTokens()) {
            String strTmp = strtok.nextToken();
            widthTmp = fmetric.stringWidth(strTmp);
            if (widthTmp <= width) continue;
            width = widthTmp;
        }
        return width;
    }

    public static int calculateTotalHeight(String str, Font font) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        FontMetrics fmetric = tk.getFontMetrics(font);
        return GraphicsLib.calculateTotalHeight(str, fmetric);
    }

    public static int calculateTotalHeight(String str, FontMetrics fmetric) {
        return fmetric.getHeight() * StringLib.getNumRows(str);
    }

    public static Rectangle calculateBoundingBox(String str, Font f, int x, int y, int pos) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        FontMetrics fmetric = tk.getFontMetrics(f);
        return GraphicsLib.calculateBoundingBox(str, fmetric, x, y, pos);
    }

    public static Rectangle calculateBoundingBox(String str, FontMetrics fmetric, int x, int y, int pos) {
        Rectangle rect = new Rectangle();
        int totalWidth = GraphicsLib.calculateTotalWidth(str, fmetric);
        int totalHeight = GraphicsLib.calculateTotalHeight(str, fmetric);
        rect.x = x;
        rect.y = y;
        rect.width = totalWidth;
        rect.height = totalHeight;
        Point pt = GraphicsLib.calculateNewPosition(rect, pos);
        rect.x = pt.x;
        rect.y = pt.y;
        return rect;
    }

    public static final Color makeTransparent(Color c, float aa) {
        if (aa >= 1.0f) {
            return c;
        }
        return GraphicsLib.makeTransparent(c, (int)(255.0f * aa));
    }

    public static final Color makeTransparent(Color c, int aa) {
        if (aa > 255) {
            aa = 255;
        } else if (aa < 0) {
            aa = 0;
        }
        int rgb = c.getRGB();
        rgb = (aa << 24) + rgb;
        return new Color(rgb, true);
    }
}

