/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.graph;

import edu.berkeley.guir.lib.satin.graph.Connection;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class StrokeGraph {
    List listStrokes = new LinkedList();
    List listConnections = new LinkedList();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.satin.graph.StrokeGraph");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public StrokeGraph() {
    }

    public StrokeGraph(StrokeGraph g) {
        HashMap<TimedStroke, TimedStroke> mapStrokes = new HashMap<TimedStroke, TimedStroke>();
        Iterator it = g.listStrokes.iterator();
        while (it.hasNext()) {
            TimedStroke stkOld = (TimedStroke)it.next();
            TimedStroke stkNew = new TimedStroke(stkOld);
            mapStrokes.put(stkOld, stkNew);
            this.addStroke(stkNew);
        }
        it = g.listConnections.iterator();
        while (it.hasNext()) {
            Connection connOld = (Connection)it.next();
            TimedStroke stkAAOld = connOld.getStrokeAA();
            TimedStroke stkBBOld = connOld.getStrokeBB();
            TimedStroke stkAANew = (TimedStroke)mapStrokes.get(stkAAOld);
            TimedStroke stkBBNew = (TimedStroke)mapStrokes.get(stkBBOld);
            if (!$assertionsDisabled && stkAANew == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && stkBBNew == null) {
                throw new AssertionError();
            }
            Connection connNew = new Connection(stkAANew, stkBBNew);
            this.addConnection(connNew);
        }
    }

    public Rectangle2D getBounds2D() {
        Iterator it = this.strokes();
        Rectangle2D gbds = null;
        Rectangle2D newbds = null;
        while (it.hasNext()) {
            TimedStroke stk = (TimedStroke)it.next();
            newbds = stk.getBounds2D(11);
            if (gbds == null) {
                gbds = newbds;
                continue;
            }
            Rectangle2D.union(gbds, newbds, gbds);
        }
        return gbds;
    }

    public void addStroke(TimedStroke stk) {
        Rectangle2D newbds = stk.getBounds2D(11);
        this.listStrokes.add(stk);
    }

    public void addConnection(TimedStroke stkAA, TimedStroke stkBB) {
        this.listConnections.add(new Connection(stkAA, stkBB));
    }

    public void addConnection(Connection conn) {
        this.listConnections.add(conn);
    }

    public Iterator strokes() {
        return this.listStrokes.iterator();
    }

    public Iterator connections() {
        return this.listConnections.iterator();
    }
}

