/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.event;

import edu.berkeley.guir.lib.awt.EventUtil;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.event.SatinEvent;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.Vector;

public abstract class StrokeEvent
extends SatinEvent
implements SatinConstants {
    MouseEvent evt;
    int evtX;
    int evtY;
    TimedStroke stroke;
    AffineTransform strokeTx;
    boolean flagDirty = false;
    Vector dispatchingPath = new Vector();

    public StrokeEvent(Object source) {
        super(source);
    }

    public StrokeEvent(Object source, TimedStroke stroke) {
        this(source);
        this.stroke = stroke;
        this.strokeTx = stroke.getTransform(11);
    }

    public StrokeEvent(Object source, TimedStroke stroke, MouseEvent evt) {
        this(source, stroke);
        this.evt = evt;
        this.evtX = evt.getX();
        this.evtY = evt.getY();
    }

    public void setDispatchingCache(Vector path) {
        this.dispatchingPath = path;
    }

    public GraphicalObject getNextDispatchee(GraphicalObject obj) {
        int index = this.dispatchingPath.indexOf(obj) + 1;
        if (index >= this.dispatchingPath.size()) {
            return null;
        }
        return (GraphicalObject)this.dispatchingPath.get(index);
    }

    public void appendDispatchee(GraphicalObject obj) {
        if (this.dispatchingPath.contains(obj)) {
            return;
        }
        this.dispatchingPath.add(obj);
    }

    public void removeDispatchee(GraphicalObject obj) {
        int index = this.dispatchingPath.indexOf(obj);
        int i = this.dispatchingPath.size() - 1;
        while (i >= index) {
            this.dispatchingPath.remove(i);
            --i;
        }
    }

    public int indexofDispatchee(GraphicalObject obj) {
        return this.dispatchingPath.indexOf(obj);
    }

    public void clearDispatchingCache() {
        this.dispatchingPath.clear();
    }

    private void clean() {
        if (this.flagDirty) {
            this.stroke.setTransform(this.strokeTx);
            this.stroke.applyTransform(this.tx);
            this.flagDirty = false;
        }
    }

    protected void onApplyTransform(AffineTransform newTx) {
        this.clean();
        this.stroke.applyTransform(newTx);
        EventUtil.applyTransform(this.evt, this.tx);
    }

    protected void onSetTransform(AffineTransform newTx) {
        this.stroke.setTransform(this.strokeTx);
        this.stroke.applyTransform(newTx);
        EventUtil.setPosition(this.evt, this.evtX, this.evtY);
        EventUtil.applyTransform(this.evt, this.tx);
    }

    public boolean isLeftButton() {
        return this.stroke.isLeftButton() && !this.stroke.isMiddleButton() && !this.stroke.isRightButton();
    }

    public boolean isMiddleButton() {
        return this.stroke.isMiddleButton();
    }

    public boolean isRightButton() {
        return this.stroke.isRightButton();
    }

    public TimedStroke getStroke() {
        this.clean();
        return this.stroke;
    }

    public void setStroke(TimedStroke stk) {
        this.stroke = stk;
        this.strokeTx = this.stroke.getTransform(11);
    }

    public TimedStroke getUntransformedStroke() {
        this.stroke.setTransform(this.strokeTx);
        return this.stroke;
    }

    public MouseEvent getMouseEvent() {
        return this.evt;
    }

    public void setMouseEvent(MouseEvent newEvt) {
        this.evt = newEvt;
    }

    public MouseEvent getUntransformedMouseEvnet() {
        EventUtil.setPosition(this.evt, this.evtX, this.evtY);
        return this.evt;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(this.getClass() + "\n");
        strbuf.append("Transform: " + this.getTransform() + "\n");
        strbuf.append("Stroke:    " + this.stroke + "\n");
        strbuf.append("Stroke Tx: " + this.strokeTx);
        return strbuf.toString();
    }
}

