/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.event;

import edu.berkeley.guir.lib.satin.event.BasicSatinEventFilter;
import edu.berkeley.guir.lib.satin.event.StrokeEvent;
import edu.berkeley.guir.lib.satin.event.StrokeEventFilter;
import java.io.Serializable;
import java.util.EventObject;

public class BasicStrokeEventFilter
extends BasicSatinEventFilter
implements StrokeEventFilter,
Serializable {
    boolean flagAcceptLeft = true;
    boolean flagAcceptMiddle = true;
    boolean flagAcceptRight = true;

    public BasicStrokeEventFilter() {
    }

    public BasicStrokeEventFilter(boolean left, boolean middle, boolean right) {
        this.setAcceptLeftButton(left);
        this.setAcceptMiddleButton(middle);
        this.setAcceptRightButton(right);
    }

    public boolean isLeftButtonAccepted() {
        return this.flagAcceptLeft;
    }

    public boolean isMiddleButtonAccepted() {
        return this.flagAcceptMiddle;
    }

    public boolean isRightButtonAccepted() {
        return this.flagAcceptRight;
    }

    public void setAcceptLeftButton(boolean flag) {
        this.flagAcceptLeft = flag;
    }

    public void setAcceptMiddleButton(boolean flag) {
        this.flagAcceptMiddle = flag;
    }

    public void setAcceptRightButton(boolean flag) {
        this.flagAcceptRight = flag;
    }

    public boolean isEventAccepted(StrokeEvent evt) {
        if (!super.isEventAccepted(evt)) {
            return false;
        }
        if (evt.isLeftButton() && !this.isLeftButtonAccepted()) {
            return false;
        }
        if (evt.isMiddleButton() && !this.isMiddleButtonAccepted()) {
            return false;
        }
        return !evt.isRightButton() || this.isRightButtonAccepted();
    }

    public boolean isEventAccepted(EventObject evt) {
        if (evt instanceof StrokeEvent) {
            return this.isEventAccepted((StrokeEvent)evt);
        }
        return false;
    }

    public Object clone() {
        return this.clone(new BasicStrokeEventFilter());
    }

    protected BasicStrokeEventFilter clone(BasicStrokeEventFilter f) {
        super.clone();
        f.flagAcceptLeft = this.flagAcceptLeft;
        f.flagAcceptMiddle = this.flagAcceptMiddle;
        f.flagAcceptRight = this.flagAcceptRight;
        return f;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer(super.toString());
        strbuf.append("\nleft-button:      " + this.isLeftButtonAccepted());
        strbuf.append("\nmiddle-button:    " + this.isMiddleButtonAccepted());
        strbuf.append("\nright-button:     " + this.isRightButtonAccepted());
        return strbuf.toString();
    }
}

