/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.command;

import edu.berkeley.guir.lib.awt.geom.AffineTransformLib;
import edu.berkeley.guir.lib.satin.command.ApplyTransformationCommand;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class ZoomCommand
extends ApplyTransformationCommand {
    static final long serialVersionUID = -5549753840349908802L;
    public static final int CENTER_AT = -5;
    public static final int KEEP_CONSTANT = -6;
    float x;
    float y;
    float scale;

    public ZoomCommand(GraphicalObject gob, double scale) {
        this(gob, scale, gob.getWidth2D(11) / 2.0f, gob.getHeight2D(11) / 2.0f, -6);
    }

    public ZoomCommand(GraphicalObject gob, double scale, double x, double y) {
        this(gob, scale, x, y, -6);
    }

    public ZoomCommand(GraphicalObject gob, double scale, double x, double y, int type) {
        super(gob, ZoomCommand.getTransform(gob, scale, x, y, type));
        this.x = (float)x;
        this.y = (float)y;
        this.scale = (float)scale;
    }

    private static AffineTransform getTransform(GraphicalObject gob, double scale, double x, double y, int type) {
        switch (type) {
            case -5: {
                return ZoomCommand.scaleAndCenterAt(gob, scale, x, y);
            }
            case -6: {
                return AffineTransformLib.scaleAndKeepConstant(scale, x, y);
            }
        }
        throw new RuntimeException("Unknown type value for zoom type");
    }

    private static AffineTransform scaleAndCenterAt(GraphicalObject gob, double scale, double x, double y) {
        Rectangle2D rect = gob.getBounds2D(12);
        AffineTransform tx = AffineTransform.getTranslateInstance(rect.getWidth() / 2.0, rect.getHeight() / 2.0);
        tx.concatenate(AffineTransform.getScaleInstance(scale, scale));
        tx.concatenate(AffineTransform.getTranslateInstance(-x, -y));
        return tx;
    }

    public String getPresentationName() {
        return "zoom (scale: " + this.scale + " x:" + this.x + " y:" + this.y + ")";
    }
}

