/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.command;

import edu.berkeley.guir.lib.satin.command.CommandImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import java.awt.geom.AffineTransform;

public class SetLocationCommand
extends CommandImpl {
    static final long serialVersionUID = 7508109613025966686L;
    private GraphicalObject gob;
    private int cdsys;
    private float newX;
    private float newY;
    private AffineTransform oldTransform;

    public SetLocationCommand(GraphicalObject gob, double x, double y) {
        this(gob, 11, x, y);
    }

    public SetLocationCommand(GraphicalObject gob, int cdsys, double x, double y) {
        this.gob = gob;
        this.cdsys = cdsys;
        this.newX = (float)x;
        this.newY = (float)y;
    }

    public String getPresentationName() {
        return "set location of graphical object";
    }

    public boolean canRedo() {
        return true;
    }

    public boolean canUndo() {
        return true;
    }

    public boolean isSignificant() {
        return true;
    }

    public void run() {
        this.oldTransform = this.gob.getTransform(11);
        this.gob.moveTo(this.cdsys, this.newX, this.newY);
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        this.gob.setTransform(this.oldTransform);
    }

    public void die() {
    }
}

