/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.command;

import edu.berkeley.guir.lib.debugging.Debug;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.command.CommandImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectGroup;

public abstract class SelectCommand
extends CommandImpl {
    static final long serialVersionUID = 4803447219676546020L;
    GraphicalObject gob;
    GraphicalObjectGroup gobs;
    int x;
    int y;
    int thresh;
    boolean flagSignificant = false;

    public SelectCommand(GraphicalObject gob) {
        this.gob = gob;
    }

    public SelectCommand(GraphicalObjectGroup gobs, int x, int y) {
        this(gobs, x, y, 5);
    }

    public SelectCommand(GraphicalObjectGroup gobs, int x, int y, int threshold) {
        this.gobs = gobs;
        this.x = x;
        this.y = y;
        this.thresh = threshold;
    }

    public String getPresentationName() {
        return "select graphical object at (" + this.x + "," + this.y + ")";
    }

    public boolean canRedo() {
        return false;
    }

    public boolean canUndo() {
        return true;
    }

    public boolean isSignificant() {
        return this.flagSignificant;
    }

    protected abstract GraphicalObject getGraphicalObject();

    public void run() {
        if (this.gob == null) {
            this.gob = this.getGraphicalObject();
        }
        if (this.gob != null) {
            SatinConstants.cmdsubsys.addSelected(this.gob);
            this.flagSignificant = true;
        }
        if (this.gob == null) {
            Debug.println("nothing nearby to select");
        } else {
            Debug.println("selected " + this.gob);
        }
    }

    public void redo() {
    }

    public void undo() {
        if (this.gob != null) {
            SatinConstants.cmdsubsys.removeSelected(this.gob);
        }
    }

    public void die() {
    }
}

