/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.command;

import edu.berkeley.guir.lib.debugging.Debug;
import edu.berkeley.guir.lib.satin.Sheet;
import edu.berkeley.guir.lib.satin.command.CommandImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPOutputStream;

public class SaveCommand
extends CommandImpl {
    static final long serialVersionUID = 7058621524256681264L;
    Sheet s;
    String strFileName;

    public SaveCommand(Sheet s, String strFileName) {
        this.s = s;
        this.strFileName = strFileName;
    }

    public SaveCommand(Sheet s, File f) {
        this(s, f.getAbsolutePath());
    }

    public String getPresentationName() {
        return "Save Sheet to file " + this.strFileName;
    }

    public boolean canRedo() {
        return false;
    }

    public boolean canUndo() {
        return false;
    }

    public boolean isSignificant() {
        return false;
    }

    public void run() {
        try {
            Debug.println("Saving...");
            FileOutputStream fostream = new FileOutputStream(this.strFileName);
            GZIPOutputStream gzostream = new GZIPOutputStream(fostream);
            ObjectOutputStream oostream = new ObjectOutputStream(gzostream);
            oostream.writeObject(this.s);
            oostream.flush();
            oostream.close();
            Debug.println("Done saving!");
        }
        catch (Exception e) {
            Debug.println(e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public void redo() {
    }

    public void undo() {
        throw new RuntimeException("Undo for this command is not currently supported");
    }
}

