/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.command;

import edu.berkeley.guir.lib.satin.Sheet;
import edu.berkeley.guir.lib.satin.command.BranchedCommandQueue;
import edu.berkeley.guir.lib.satin.command.Command;
import edu.berkeley.guir.lib.satin.command.RemoteCommandQueue;
import edu.berkeley.guir.lib.satin.remote.IOEvent;
import edu.berkeley.guir.lib.satin.remote.InOutMgr;
import edu.berkeley.guir.lib.satin.remote.RemoteSocketMgr;

public class RemoteBranchedCommandQueue
extends BranchedCommandQueue
implements RemoteCommandQueue {
    private RemoteSocketMgr m_remoteSocketMgr = null;
    private InOutMgr m_saveMgr = null;
    private Sheet m_sheet;

    public RemoteBranchedCommandQueue(Sheet s) {
        this.m_sheet = s;
    }

    public synchronized void doCommand(Command cmd) {
        super.doCommand(cmd);
        if (this.m_remoteSocketMgr != null) {
            System.out.println("Sending Event");
            this.m_remoteSocketMgr.postOutgoingEvent(cmd.getWrappedXML());
        }
        if (this.m_saveMgr != null) {
            System.out.println("Saving Event");
            this.m_saveMgr.postOutgoingEvent(cmd.getWrappedXML());
        }
    }

    public synchronized void doLocalCommand(Command cmd) {
        super.doCommand(cmd);
        if (this.m_saveMgr != null) {
            System.out.println("Saving Event");
            this.m_saveMgr.postOutgoingEvent(cmd.getWrappedXML());
        }
    }

    public void undo() {
        super.undo();
        System.out.println("RemoteQ: NEED TO IMPLEMENT REMOTE UNDO");
    }

    public void redo() {
        super.redo();
        System.out.println("RemoteQ: NEED TO IMPLEMENT REMOTE REDO");
    }

    public void setRemoteSocketMgr(RemoteSocketMgr mgr) {
        this.m_remoteSocketMgr = mgr;
    }

    public void setSaveMgr(InOutMgr mgr) {
        this.m_saveMgr = mgr;
    }

    public void handleRemoteEvent(IOEvent event) {
        System.out.println("BranchedCmdQ: remote event received");
        this.m_sheet.addCommandToSheet(event.getXML());
    }
}

