/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.command;

import edu.berkeley.guir.lib.satin.Sheet;
import edu.berkeley.guir.lib.satin.command.CommandImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PhantomMoveCommand
extends CommandImpl {
    private List gobs = new LinkedList();
    private Point2D[] oldRelLocs;
    private Point2D[] newRelLocs;

    public PhantomMoveCommand(Iterator it, Point2D[] oldRelLocs, Point2D[] newRelLocs) {
        while (it.hasNext()) {
            this.gobs.add(it.next());
        }
        this.oldRelLocs = oldRelLocs;
        this.newRelLocs = newRelLocs;
    }

    public String getPresentationName() {
        return "phantom move location of graphical objects";
    }

    public boolean canRedo() {
        return true;
    }

    public boolean canUndo() {
        return true;
    }

    public boolean isSignificant() {
        return true;
    }

    public void run() {
    }

    public void redo() {
        Iterator it = this.gobs.iterator();
        int i = 0;
        while (it.hasNext()) {
            GraphicalObject gob = (GraphicalObject)it.next();
            gob.moveTo(11, this.newRelLocs[i]);
            ++i;
        }
    }

    public void undo() {
        GraphicalObject gob;
        Iterator it = this.gobs.iterator();
        int i = 0;
        Sheet sheet = null;
        if (it.hasNext()) {
            gob = (GraphicalObject)it.next();
            sheet = gob.getSheet();
            sheet.bufferUpcomingRender(100);
            gob.moveTo(11, this.oldRelLocs[i]);
            ++i;
        }
        while (it.hasNext()) {
            gob = (GraphicalObject)it.next();
            gob.moveTo(11, this.oldRelLocs[i]);
            ++i;
        }
        if (i > 0) {
            sheet.bufferUpcomingRender(1);
            sheet.damage(22);
            sheet.damage(21);
        }
    }

    public void die() {
    }
}

