/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.command;

import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.command.Clipboard;
import edu.berkeley.guir.lib.satin.command.CommandImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectGroup;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;
import java.util.Vector;

public class PasteCommand
extends CommandImpl {
    static final long serialVersionUID = -4186251694942941113L;
    protected static Clipboard myClipboard = SatinConstants.clipboard;
    protected GraphicalObjectGroup gobs;
    protected Vector pastedList;
    protected boolean flagLocation;
    protected float x;
    protected float y;

    public PasteCommand(GraphicalObjectGroup gobs) {
        this.gobs = gobs;
        this.flagLocation = false;
    }

    public PasteCommand(GraphicalObjectGroup gobs, double x, double y) {
        this.gobs = gobs;
        this.flagLocation = true;
        this.x = (float)x;
        this.y = (float)y;
    }

    public PasteCommand(GraphicalObjectGroup gobs, Point2D pt) {
        this(gobs, pt.getX(), pt.getY());
    }

    public static void setClipboard(Clipboard newClipboard) {
        myClipboard = newClipboard;
    }

    public String getPresentationName() {
        return "paste graphical object";
    }

    public boolean canRedo() {
        return true;
    }

    public boolean canUndo() {
        return true;
    }

    public boolean isSignificant() {
        return true;
    }

    public void run() {
        GraphicalObject gob;
        RectangularShape rect = null;
        AffineTransform xform = null;
        AffineTransform gobsInvAbsXform = this.gobs.getInverseTransform(12);
        gobsInvAbsXform.preConcatenate(this.gobs.getSheet().getTransform(12));
        Iterator it = myClipboard.getContents();
        Iterator xformIt = myClipboard.getParentAbsXforms();
        this.pastedList = new Vector();
        while (it.hasNext() && xformIt.hasNext()) {
            Object obj = it.next();
            xform = (AffineTransform)xformIt.next();
            if (!(obj instanceof GraphicalObject)) continue;
            this.pastedList.addElement(obj);
            gob = (GraphicalObject)obj;
            xform.preConcatenate(gobsInvAbsXform);
            gob.applyTransform(xform);
            this.gobs.addToFront(gob, 6);
            if (!this.flagLocation) {
                gob.moveBy(12, 5.0, 5.0);
            }
            if (rect == null) {
                rect = gob.getBounds2D(11);
                continue;
            }
            Rectangle.union((Rectangle2D)rect, gob.getBounds2D(11), (Rectangle2D)rect);
        }
        if (this.flagLocation && this.pastedList.size() > 0) {
            it = this.pastedList.iterator();
            while (it.hasNext()) {
                gob = (GraphicalObject)it.next();
                gob.moveBy(11, (double)this.x - rect.getX(), (double)this.y - rect.getY());
            }
        }
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        Iterator it = this.pastedList.iterator();
        while (it.hasNext()) {
            GraphicalObject gob = (GraphicalObject)it.next();
            gob.delete();
        }
    }

    public void die() {
    }
}

