/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.command;

import edu.berkeley.guir.lib.debugging.Debug;
import edu.berkeley.guir.lib.satin.Sheet;
import edu.berkeley.guir.lib.satin.command.CommandImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.zip.GZIPInputStream;

public class OpenCommand
extends CommandImpl {
    static final long serialVersionUID = -8686441148093642921L;
    Sheet s;
    String strFileName;

    public OpenCommand(Sheet s, String strFileName) {
        this.s = s;
        this.strFileName = strFileName;
    }

    public OpenCommand(Sheet s, File f) {
        this(s, f.getAbsolutePath());
    }

    public String getPresentationName() {
        return "Open Sheet from file " + this.strFileName;
    }

    public boolean canRedo() {
        return false;
    }

    public boolean canUndo() {
        return false;
    }

    public boolean isSignificant() {
        return true;
    }

    public void run() {
        try {
            Debug.println("Opening...");
            FileInputStream fistream = new FileInputStream(this.strFileName);
            GZIPInputStream gzistream = new GZIPInputStream(fistream);
            ObjectInputStream oistream = new ObjectInputStream(gzistream);
            Object obj = oistream.readObject();
            oistream.close();
            this.s.setSheet((Sheet)obj);
            this.s.damage(21);
            Debug.println("Done opening!");
        }
        catch (Exception e) {
            Debug.println(e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public void redo() {
    }

    public void undo() {
        throw new RuntimeException("Undo for this command is not currently supported");
    }
}

