/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.command;

import edu.berkeley.guir.lib.satin.command.CommandImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import java.awt.geom.AffineTransform;

public class MoveCommand
extends CommandImpl {
    static final long serialVersionUID = 7508109613025966686L;
    public static final String TAG_NAME = "MOVE";
    private GraphicalObject gob;
    private int cdsys;
    private int dx;
    private int dy;
    private int dz;
    private AffineTransform oldTransform;

    public MoveCommand(GraphicalObject gob, int dx, int dy, int dz) {
        this(gob, 11, dx, dy, dz);
    }

    public MoveCommand(GraphicalObject gob, int cdsys, int dx, int dy, int dz) {
        this.gob = gob;
        this.cdsys = cdsys;
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
    }

    public String getPresentationName() {
        return "move graphical object";
    }

    public boolean canRedo() {
        return true;
    }

    public boolean canUndo() {
        return true;
    }

    public boolean isSignificant() {
        return true;
    }

    public void run() {
        this.oldTransform = this.gob.getTransform(11);
        this.gob.moveBy(this.cdsys, this.dx, this.dy);
        if (this.dz > 0) {
            this.gob.bringUpNLayers(this.dz);
        } else {
            this.gob.bringDownNLayers(this.dz);
        }
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        this.gob.setTransform(this.oldTransform);
        if (this.dz > 0) {
            this.gob.bringDownNLayers(this.dz);
        } else {
            this.gob.bringUpNLayers(this.dz);
        }
    }

    public void die() {
    }

    public String getTagName() {
        return TAG_NAME;
    }
}

