/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.command;

import edu.berkeley.guir.lib.satin.command.Command;
import edu.berkeley.guir.lib.satin.command.CommandImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class MacroCommand
extends CommandImpl {
    static final long serialVersionUID = 5051203481188186715L;
    private List vecCommands = new ArrayList();

    public void addCommand(Command cmd) {
        this.vecCommands.add(cmd);
    }

    public void removeCommand(Command cmd) {
        this.vecCommands.remove(cmd);
    }

    public void clearCommands() {
        this.vecCommands.clear();
    }

    public String getPresentationName() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("[");
        Iterator i = this.vecCommands.iterator();
        while (i.hasNext()) {
            Command cmd = (Command)i.next();
            strbuf.append(String.valueOf(cmd.getPresentationName()) + ", ");
        }
        strbuf.append("]");
        return "Macro Command " + strbuf.toString();
    }

    public String getRedoPresentationName() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("[");
        Iterator i = this.vecCommands.iterator();
        while (i.hasNext()) {
            Command cmd = (Command)i.next();
            strbuf.append(String.valueOf(cmd.getRedoPresentationName()) + ", ");
        }
        strbuf.append("]");
        return "Redo Macro Command " + strbuf.toString();
    }

    public String getUndoPresentationName() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("[");
        Iterator i = this.vecCommands.iterator();
        while (i.hasNext()) {
            Command cmd = (Command)i.next();
            strbuf.append(String.valueOf(cmd.getUndoPresentationName()) + ", ");
        }
        strbuf.append("]");
        return "Undo Macro Command " + strbuf.toString();
    }

    public boolean canRedo() {
        return true;
    }

    public boolean canUndo() {
        return true;
    }

    public boolean isSignificant() {
        return true;
    }

    public boolean isEmpty() {
        return this.vecCommands.isEmpty();
    }

    public void run() {
        Iterator i = this.vecCommands.iterator();
        while (i.hasNext()) {
            Command cmd = (Command)i.next();
            cmd.execute();
        }
    }

    public void redo() {
        Iterator i = this.vecCommands.iterator();
        while (i.hasNext()) {
            Command cmd = (Command)i.next();
            cmd.redo();
        }
    }

    public void undo() {
        int size = this.vecCommands.size();
        ListIterator i = this.vecCommands.listIterator(size);
        while (i.hasPrevious()) {
            Command cmd = (Command)i.previous();
            cmd.undo();
        }
    }

    public void die() {
    }
}

