/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.command;

import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.Sheet;
import edu.berkeley.guir.lib.satin.command.CommandImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectGroup;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.LinkedList;

public class InsertCommand
extends CommandImpl {
    static final long serialVersionUID = 7114369136904443157L;
    public static final String TAG_NAME = "INSERT";
    GraphicalObjectGroup gobs;
    LinkedList list = new LinkedList();
    int pos = 6;
    Sheet s = null;

    public InsertCommand(GraphicalObjectGroup gobs) {
        this.gobs = gobs;
    }

    public InsertCommand(GraphicalObjectGroup gobs, GraphicalObject gob) {
        this.addGraphicalObject(gob);
        this.gobs = gobs;
    }

    public InsertCommand(GraphicalObjectGroup gobs, GraphicalObject gob, int pos) {
        this.addGraphicalObject(gob);
        this.gobs = gobs;
        this.pos = pos;
    }

    public InsertCommand(GraphicalObjectGroup gobs, Iterator it, int pos) {
        while (it.hasNext()) {
            this.addGraphicalObject((GraphicalObject)it.next());
        }
        this.gobs = gobs;
        this.pos = pos;
    }

    public void setAddPolicy(int val) {
        this.pos = val;
    }

    public void addGraphicalObject(GraphicalObject gob) {
        this.list.add(gob);
    }

    public void removeGraphicalObject(GraphicalObject gob) {
        this.list.remove(gob);
    }

    public void clearGraphicalObjects() {
        this.list.clear();
    }

    public String getPresentationName() {
        return "insert graphical object";
    }

    public boolean canRedo() {
        return true;
    }

    public boolean canUndo() {
        return true;
    }

    public boolean isSignificant() {
        return true;
    }

    public Sheet getAssociatedSheet() {
        Iterator it = this.list.iterator();
        if (it.hasNext()) {
            return ((GraphicalObject)it.next()).getSheet();
        }
        return null;
    }

    public void run() {
        Iterator it = this.list.iterator();
        GraphicalObject gob = null;
        while (it.hasNext()) {
            gob = (GraphicalObject)it.next();
            this.gobs.addToFront(gob, this.pos);
        }
        if (gob != null) {
            SatinConstants.cmdsubsys.setLastGraphicalObject(gob);
        }
    }

    public void redo() {
        Iterator it = this.list.iterator();
        GraphicalObject gob = null;
        while (it.hasNext()) {
            gob = (GraphicalObject)it.next();
            this.gobs.addToFront(gob, 6);
        }
        if (gob != null) {
            SatinConstants.cmdsubsys.setLastGraphicalObject(gob);
        }
    }

    public synchronized void undo() {
        Iterator it = this.list.iterator();
        Rectangle2D damageRect = null;
        Sheet sheet = null;
        while (it.hasNext()) {
            GraphicalObject gob = (GraphicalObject)it.next();
            if (sheet == null) {
                sheet = gob.getSheet();
            }
            damageRect = damageRect == null ? gob.getBounds2D(12) : damageRect.createUnion(gob.getBounds2D(12));
            gob.delete();
        }
        if (sheet != null) {
            sheet.damage(21, damageRect);
        }
    }

    public void die() {
    }

    protected String getTagName() {
        return TAG_NAME;
    }
}

