/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.command;

import edu.berkeley.guir.lib.satin.Sheet;
import edu.berkeley.guir.lib.satin.command.CommandImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectGroup;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectLib;
import java.awt.geom.Rectangle2D;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class DeleteCommand
extends CommandImpl {
    private static final long serialVersionUID = -9014455929012559983L;
    public static final String TAG_NAME = "DELETE";
    protected Map gobToParent = new TreeMap(new InternalLayerReverseComparator());
    protected SortedMap layerToGob = new TreeMap();
    protected Map gobToAbsLayer = new HashMap();

    public DeleteCommand() {
    }

    public DeleteCommand(GraphicalObject gob) {
        this.addGraphicalObject(gob);
    }

    public DeleteCommand(Iterator it) {
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof GraphicalObject)) continue;
            this.addGraphicalObject((GraphicalObject)obj);
        }
    }

    public DeleteCommand(Vector gobs) {
        this(gobs.iterator());
    }

    public void addGraphicalObject(GraphicalObject gob) {
        this.gobToAbsLayer.put(gob, gob.getAbsoluteLayer());
        this.gobToParent.put(gob, gob.getParentGroup());
        Integer relLayer = new Integer(gob.getRelativeLayer());
        if (!this.layerToGob.containsKey(relLayer)) {
            this.layerToGob.put(relLayer, new LinkedList());
        }
        ((List)this.layerToGob.get(relLayer)).add(gob);
    }

    public void removeGraphicalObject(GraphicalObject gob) {
        this.gobToParent.remove(gob);
        Integer relLayer = new Integer(gob.getRelativeLayer());
        ((List)this.layerToGob.get(relLayer)).remove(gob);
    }

    public void clearGraphicalObjects() {
        this.gobToParent.clear();
        this.layerToGob.clear();
    }

    public String getPresentationName() {
        return "Delete Graphical Object";
    }

    public boolean canRedo() {
        return false;
    }

    public boolean canUndo() {
        return true;
    }

    public boolean isSignificant() {
        return true;
    }

    public void run() {
        Set keys = this.gobToParent.keySet();
        Iterator it = keys.iterator();
        Rectangle2D damageRect = null;
        Sheet sheet = null;
        while (it.hasNext()) {
            GraphicalObject gob = (GraphicalObject)it.next();
            if (sheet == null) {
                sheet = gob.getSheet();
            }
            damageRect = damageRect == null ? gob.getBounds2D(12) : damageRect.createUnion(gob.getBounds2D(12));
            gob.delete();
        }
        if (sheet != null) {
            sheet.damage(21, damageRect);
        }
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        Iterator layerIt = this.layerToGob.keySet().iterator();
        while (layerIt.hasNext()) {
            Integer layer = (Integer)layerIt.next();
            List gobs = (List)this.layerToGob.get(layer);
            Iterator gobIt = gobs.iterator();
            while (gobIt.hasNext()) {
                GraphicalObject gob = (GraphicalObject)gobIt.next();
                GraphicalObjectGroup parent = (GraphicalObjectGroup)this.gobToParent.get(gob);
                parent.addToFront(gob);
                parent.setRelativeLayer(gob, layer);
                parent.damage(21);
            }
        }
    }

    public void die() {
    }

    protected String getTagName() {
        return TAG_NAME;
    }

    public class InternalLayerReverseComparator
    implements Comparator {
        public int compare(Object gob1, Object gob2) {
            return -GraphicalObjectLib.compareLayers((List)DeleteCommand.this.gobToAbsLayer.get(gob1), (List)DeleteCommand.this.gobToAbsLayer.get(gob2));
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }
}

