/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.command;

import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.command.Clipboard;
import edu.berkeley.guir.lib.satin.command.CommandImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.util.LayerReverseComparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class CopyCommand
extends CommandImpl {
    static final long serialVersionUID = -3875655884154094856L;
    protected static Clipboard myClipboard = SatinConstants.clipboard;
    protected Set copySet = new TreeSet(new LayerReverseComparator());

    public CopyCommand() {
    }

    public CopyCommand(GraphicalObject gob) {
        this.addGraphicalObject(gob);
    }

    public CopyCommand(Iterator it) {
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof GraphicalObject)) continue;
            this.addGraphicalObject((GraphicalObject)obj);
        }
    }

    public CopyCommand(Vector gobs) {
        this(gobs.iterator());
    }

    public void addGraphicalObject(GraphicalObject gob) {
        this.copySet.add(gob);
    }

    public void removeGraphicalObject(GraphicalObject gob) {
        this.copySet.remove(gob);
    }

    public void clearGraphicalObjects() {
        this.copySet.clear();
    }

    public String getPresentationName() {
        return "copy graphical object to clipboard";
    }

    public boolean canRedo() {
        return false;
    }

    public boolean canUndo() {
        return false;
    }

    public boolean isSignificant() {
        return false;
    }

    public static void setClipboard(Clipboard newClipboard) {
        myClipboard = newClipboard;
    }

    public void run() {
        if (this.copySet.isEmpty()) {
            return;
        }
        myClipboard.clearClipboard();
        myClipboard.copyToClipboard(this.copySet.iterator());
    }

    public void redo() {
    }

    public void undo() {
    }

    public void die() {
    }
}

