/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.command;

import edu.berkeley.guir.lib.debugging.Debug;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.Sheet;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectCollection;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectCollectionImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectLib;
import edu.berkeley.guir.lib.satin.watch.WatchableImpl;
import edu.berkeley.guir.lib.util.StringLib;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.LinkedList;

public class CommandSubsystem
extends WatchableImpl
implements SatinConstants,
MouseListener,
MouseMotionListener {
    static long serialVersionUID = 91472039982497383L;
    public static final String SELECTED_ADDED = "SELECTED_ADDED";
    public static final String SELECTED_REMOVED = "SELECTED_REMOVED";
    int lastX;
    int lastY;
    GraphicalObjectCollection selectedGobs = new GraphicalObjectCollectionImpl();
    GraphicalObject lastGob;
    EventQueue evtqueue;
    Sheet sheet;
    PropertyChangeSupport csupport = new PropertyChangeSupport(this);

    public void initializeCommandSubsystem(Sheet newSheet) {
        newSheet.addMouseListener(SatinConstants.cmdsubsys);
        this.sheet = newSheet;
    }

    private void processMouseEvent(MouseEvent evt) {
        this.lastX = evt.getX();
        this.lastY = evt.getY();
    }

    public void mouseClicked(MouseEvent evt) {
        this.processMouseEvent(evt);
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseDragged(MouseEvent evt) {
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        this.processMouseEvent(evt);
    }

    public void mouseReleased(MouseEvent evt) {
        this.processMouseEvent(evt);
    }

    private EventQueue getEventQueue() {
        try {
            if (this.evtqueue != null) {
                return this.evtqueue;
            }
            this.evtqueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        }
        catch (Exception e) {
            Debug.println("Cannot retrieve event queue - cannot activate widgets");
            Debug.println(e);
        }
        return this.evtqueue;
    }

    public void postEvent(AWTEvent evt) {
        this.getEventQueue().postEvent(evt);
    }

    public boolean isSelected(GraphicalObject gob) {
        if (gob == null) {
            return false;
        }
        return this.selectedGobs.contains(gob);
    }

    public void setSelected(GraphicalObjectCollection g) {
        this.selectedGobs = g;
        if (this.sheet != null) {
            this.sheet.damage(21, this.selectedGobs.getCollectionBounds2D(12));
        }
    }

    public void clearSelected() {
        Iterator it = this.selectedGobs.getForwardIterator();
        LinkedList list = new LinkedList();
        while (it.hasNext()) {
            list.add(it.next());
        }
        this.selectedGobs.clear();
        it = list.iterator();
        while (it.hasNext()) {
            GraphicalObject gob = (GraphicalObject)it.next();
            gob.damage(21);
            this.csupport.firePropertyChange(SELECTED_REMOVED, gob, null);
        }
    }

    public void removeSelected(GraphicalObject gob) {
        if (this.selectedGobs.remove(gob) != null && this.sheet != null) {
            this.sheet.damage(21, gob);
            this.csupport.firePropertyChange(SELECTED_REMOVED, gob, null);
        }
    }

    public void addSelected(GraphicalObject gob) {
        if (gob.isSelectable()) {
            this.selectedGobs.addToBack(gob);
            if (this.sheet != null) {
                this.sheet.damage(21, gob);
            }
            this.csupport.firePropertyChange(SELECTED_ADDED, null, gob);
        }
    }

    public void addSelected(Iterator it) {
        while (it.hasNext()) {
            this.addSelected((GraphicalObject)it.next());
        }
    }

    public Iterator getSelected() {
        return ((GraphicalObjectCollection)this.selectedGobs.clone()).getForwardIterator();
    }

    public GraphicalObjectCollection getSelectedCollection() {
        return this.selectedGobs;
    }

    public Point getAbsoluteLastLocation() {
        return new Point(this.lastX, this.lastY);
    }

    public Point getAbsoluteLastLocation(Point pt) {
        pt.x = this.lastX;
        pt.y = this.lastY;
        return pt;
    }

    public int getAbsoluteLastXLocation() {
        return this.lastX;
    }

    public int getAbsoluteLastYLocation() {
        return this.lastY;
    }

    public Point getLocalLastLocation(GraphicalObject gob) {
        return this.getLocalLastLocation(gob, new Point());
    }

    public Point getLocalLastLocation(GraphicalObject gob, Point pt) {
        Point ptTmp = this.getAbsoluteLastLocation();
        GraphicalObjectLib.absoluteToLocal(gob, ptTmp, pt);
        return pt;
    }

    public int getLocalLastXLocation(GraphicalObject gob) {
        Point pt = this.getLocalLastLocation(gob);
        return pt.x;
    }

    public int getLocalLastYLocation(GraphicalObject gob) {
        Point pt = this.getLocalLastLocation(gob);
        return pt.y;
    }

    public void setLastGraphicalObject(GraphicalObject gob) {
        this.lastGob = gob;
    }

    public GraphicalObject getLastGraphicalObject() {
        return this.lastGob;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.csupport.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String strPropertyName, PropertyChangeListener l) {
        this.csupport.addPropertyChangeListener(strPropertyName, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.csupport.removePropertyChangeListener(l);
    }

    public void removePropertyChangeListener(String strPropertyName, PropertyChangeListener l) {
        this.csupport.removePropertyChangeListener(strPropertyName, l);
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("Last Pos:       " + this.getAbsoluteLastLocation());
        strbuf.append("\nSelected GObs:  " + this.getSelectedCollection());
        strbuf.append("\nLast GOb Added: [");
        if (this.lastGob != null) {
            strbuf.append("\n" + StringLib.indent(this.getLastGraphicalObject().toString(), 3) + "\n");
        }
        strbuf.append("]\n");
        return strbuf.toString();
    }
}

