/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.command;

import edu.berkeley.guir.lib.satin.Sheet;
import edu.berkeley.guir.lib.satin.command.Command;
import edu.berkeley.guir.lib.satin.command.CommandQueue;
import edu.berkeley.guir.lib.satin.command.LinearCommandQueue;
import edu.berkeley.guir.lib.satin.command.RemoteCommandQueue;
import edu.berkeley.guir.lib.satin.remote.RemoteSocketMgr;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.undo.UndoableEdit;

public class CommandQueueManager
implements CommandQueue {
    private CommandQueue defaultCommandQ = new LinearCommandQueue();
    private Vector auxillaryCommandQs = new Vector();

    public void setCommandQueue(CommandQueue q) {
        this.defaultCommandQ = q;
    }

    public CommandQueue getCommandQueue() {
        return this.defaultCommandQ;
    }

    public void doCommand(Command cmd) {
        Sheet mySheet = cmd.getAssociatedSheet();
        if (mySheet == null) {
            this.defaultCommandQ.doCommand(cmd);
            return;
        }
        Enumeration auxQs = this.auxillaryCommandQs.elements();
        while (auxQs.hasMoreElements()) {
            SheetWithCommandQueue q = (SheetWithCommandQueue)auxQs.nextElement();
            if (q.getSheet() != mySheet) continue;
            q.getCommandQueue().doCommand(cmd);
            return;
        }
        this.defaultCommandQ.doCommand(cmd);
    }

    public void clear() {
        this.defaultCommandQ.clear();
        this.auxillaryCommandQs = new Vector();
    }

    public void setRemoteSocketMgr(RemoteSocketMgr m) {
        if (this.defaultCommandQ instanceof RemoteCommandQueue) {
            ((RemoteCommandQueue)((Object)this.defaultCommandQ)).setRemoteSocketMgr(m);
        }
    }

    public void dump() {
        this.defaultCommandQ.dump();
    }

    public boolean addEdit(UndoableEdit anEdit) {
        return this.defaultCommandQ.addEdit(anEdit);
    }

    public boolean canRedo() {
        return this.defaultCommandQ.canRedo();
    }

    public boolean canUndo() {
        return this.defaultCommandQ.canUndo();
    }

    public void die() {
        this.defaultCommandQ.die();
    }

    public String getPresentationName() {
        return this.defaultCommandQ.getPresentationName();
    }

    public String getRedoPresentationName() {
        return this.defaultCommandQ.getRedoPresentationName();
    }

    public String getUndoPresentationName() {
        return this.defaultCommandQ.getUndoPresentationName();
    }

    public boolean isSignificant() {
        return this.defaultCommandQ.isSignificant();
    }

    public void redo() {
        this.defaultCommandQ.redo();
    }

    public void undo() {
        this.defaultCommandQ.undo();
    }

    public boolean replaceEdit(UndoableEdit anEdit) {
        return this.defaultCommandQ.replaceEdit(anEdit);
    }

    public void createQueueFor(Sheet mySheet) {
        SheetWithCommandQueue newQ = new SheetWithCommandQueue(mySheet);
        this.auxillaryCommandQs.add(newQ);
    }

    public CommandQueue getQueueFor(Sheet mySheet) {
        Enumeration auxQs = this.auxillaryCommandQs.elements();
        while (auxQs.hasMoreElements()) {
            SheetWithCommandQueue q = (SheetWithCommandQueue)auxQs.nextElement();
            if (q.getSheet() != mySheet) continue;
            return q.getCommandQueue();
        }
        return this.defaultCommandQ;
    }

    public void setCommandQueueFor(Sheet mySheet, CommandQueue myQ) {
        Enumeration auxQs = this.auxillaryCommandQs.elements();
        while (auxQs.hasMoreElements()) {
            SheetWithCommandQueue q = (SheetWithCommandQueue)auxQs.nextElement();
            if (q.getSheet() != mySheet) continue;
            q.setCommandQueue(myQ);
        }
    }

    private class SheetWithCommandQueue {
        private CommandQueue q = new LinearCommandQueue();
        private Sheet pairedSheet = null;

        public SheetWithCommandQueue(Sheet paired) {
            this.pairedSheet = paired;
        }

        public Sheet getSheet() {
            return this.pairedSheet;
        }

        public void setCommandQueue(CommandQueue q) {
            this.q = q;
        }

        public CommandQueue getCommandQueue() {
            return this.q;
        }
    }
}

