/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.command;

import edu.berkeley.guir.lib.collection.HashBag;
import edu.berkeley.guir.lib.debugging.Debug;
import edu.berkeley.guir.lib.satin.Sheet;
import edu.berkeley.guir.lib.satin.command.Command;
import edu.berkeley.guir.lib.satin.command.NotEnabledException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.undo.UndoableEdit;

public abstract class CommandImpl
implements Command,
Serializable {
    static final long serialVersionUID = 6720549862372374770L;
    static HashBag enabledCounter = new HashBag();
    long executionTime;
    protected Object m_author = null;
    protected String m_device = "";

    private boolean isEnabled(String strClassName) {
        int count = enabledCounter.size(strClassName);
        if (count < 0) {
            throw new RuntimeException("Unbalanced number of enable / disable");
        }
        return count == 0;
    }

    private void enable(String strClassName) {
        enabledCounter.remove(strClassName);
    }

    private void disable(String strClassName) {
        enabledCounter.add(strClassName);
    }

    public final boolean isEnabled() {
        return this.isEnabled(this.getClass().getName());
    }

    public final boolean isDisabled() {
        return !this.isEnabled();
    }

    public void enable() {
        this.enable(this.getClass().getName());
    }

    public void disable() {
        this.disable(this.getClass().getName());
    }

    public boolean addEdit(UndoableEdit anEdit) {
        return false;
    }

    public boolean replaceEdit(UndoableEdit anEdit) {
        return false;
    }

    public void setExecutionTime() {
        this.setExecutionTime(System.currentTimeMillis());
    }

    public void setExecutionTime(long l) {
        this.executionTime = l;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public Iterator getOperands() {
        return new LinkedList().iterator();
    }

    public boolean isOperand(Object o) {
        Iterator i = this.getOperands();
        while (i.hasNext()) {
            if (!i.next().equals(o)) continue;
            return true;
        }
        return false;
    }

    public void setAuthor(Object author) {
        this.m_author = author;
    }

    public Object getAuthor() {
        return this.m_author;
    }

    public void setDevice(String device) {
        this.m_device = device;
    }

    public String getDevice() {
        return this.m_device;
    }

    public String getWrappedXML() {
        return this.wrapXML(this.toXML());
    }

    protected String toXML() {
        return "<" + this.getClass() + "></" + this.getClass() + ">";
    }

    protected String wrapXML(String wrapMe) {
        return "<" + this.getTagName() + ">" + wrapMe + "</" + this.getTagName() + ">";
    }

    protected String getTagName() {
        return "CMD";
    }

    public String getPresentationName() {
        return this.getClass().getName();
    }

    public String getRedoPresentationName() {
        if (this.canRedo()) {
            return "redo " + this.getPresentationName();
        }
        return "redo not supported - " + this.getPresentationName();
    }

    public String getUndoPresentationName() {
        if (this.canUndo()) {
            return "undo " + this.getPresentationName();
        }
        return "undo not supported - " + this.getPresentationName();
    }

    public boolean canRedo() {
        return false;
    }

    public boolean canUndo() {
        return false;
    }

    public boolean isSignificant() {
        return false;
    }

    public Sheet getAssociatedSheet() {
        return null;
    }

    public void redo() {
    }

    public void undo() {
    }

    public void die() {
    }

    public final void execute() {
        if (!this.isEnabled()) {
            throw new NotEnabledException(this);
        }
        this.setExecutionTime();
        this.run();
        Debug.println("executing " + this.getPresentationName());
    }

    protected abstract void run();

    public String toString() {
        return enabledCounter.toString();
    }

    public static String debug() {
        return enabledCounter.toString();
    }
}

