/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.command;

import edu.berkeley.guir.lib.debugging.Debug;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectCollection;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectCollectionImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectGroup;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Clipboard
implements Serializable,
SatinConstants {
    static final long serialVersionUID = -8681551454772904393L;
    protected GraphicalObjectCollection gobcol = new GraphicalObjectCollectionImpl();
    protected List parentAbsXforms = new LinkedList();
    protected Map fromOrigToClipboard = new HashMap();
    protected Map fromClipboardToPasted = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.satin.command.Clipboard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    private void mapOrigToClone(Map origToClone, GraphicalObject orig, GraphicalObject clone) {
        origToClone.put(orig, clone);
        if (orig instanceof GraphicalObjectGroup) {
            GraphicalObjectGroup origGrp = (GraphicalObjectGroup)orig;
            GraphicalObjectGroup cloneGrp = (GraphicalObjectGroup)clone;
            Iterator origIt = origGrp.getForwardIterator();
            Iterator cloneIt = cloneGrp.getForwardIterator();
            while (origIt.hasNext()) {
                GraphicalObject origChild = (GraphicalObject)origIt.next();
                GraphicalObject cloneChild = (GraphicalObject)cloneIt.next();
                this.mapOrigToClone(origToClone, origChild, cloneChild);
            }
        }
    }

    public GraphicalObjectCollection getContentsCollection() {
        GraphicalObjectCollection gobcolClone = (GraphicalObjectCollection)this.gobcol.deepClone();
        if (!$assertionsDisabled && this.gobcol.numElements() != gobcolClone.numElements()) {
            throw new AssertionError();
        }
        this.fromClipboardToPasted.clear();
        Iterator origIt = this.gobcol.getForwardIterator();
        Iterator cloneIt = gobcolClone.getForwardIterator();
        while (origIt.hasNext()) {
            GraphicalObject gob = (GraphicalObject)origIt.next();
            GraphicalObject gobClone = (GraphicalObject)cloneIt.next();
            this.mapOrigToClone(this.fromClipboardToPasted, gob, gobClone);
        }
        return gobcolClone;
    }

    public Iterator getContents() {
        return this.getContentsCollection().getForwardIterator();
    }

    public Iterator getParentAbsXforms() {
        LinkedList<AffineTransform> copy = new LinkedList<AffineTransform>();
        Iterator it = this.parentAbsXforms.iterator();
        while (it.hasNext()) {
            AffineTransform xform = (AffineTransform)it.next();
            copy.add(new AffineTransform(xform));
        }
        return copy.iterator();
    }

    public void copyToClipboard(GraphicalObject gob) {
        try {
            GraphicalObject gobTmp = (GraphicalObject)gob.deepClone();
            this.mapOrigToClone(this.fromOrigToClipboard, gob, gobTmp);
            this.gobcol.addToBack(gobTmp);
            gobTmp.removeWatcher(this.gobcol);
            if (gob.getParentGroup() != null) {
                AffineTransform xform = gob.getParentGroup().getTransform(12);
                xform.preConcatenate(gob.getSheet().getInverseTransform(12));
                this.parentAbsXforms.add(xform);
            } else {
                this.parentAbsXforms.add(null);
            }
        }
        catch (Exception e) {
            Debug.println("Argh, matey! Ye have a GraphicalObject clone error!");
            Debug.println(e);
        }
    }

    public void copyToClipboard(Iterator it) {
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof GraphicalObject)) continue;
            this.copyToClipboard((GraphicalObject)obj);
        }
    }

    public void removeFromClipboard(GraphicalObject gob) {
        this.gobcol.remove(gob);
    }

    public void clearClipboard() {
        this.gobcol.clear();
        this.parentAbsXforms.clear();
        this.fromOrigToClipboard.clear();
        this.fromClipboardToPasted.clear();
    }

    public void setContents(Iterator it) {
        this.clearClipboard();
        this.copyToClipboard(it);
    }

    public String toString() {
        return this.gobcol.toString();
    }
}

