/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.command;

import edu.berkeley.guir.lib.satin.command.Command;
import java.util.Iterator;
import java.util.LinkedList;

public class BranchedCommandQueueNode {
    private Command command;
    private BranchedCommandQueueNode parent;
    private LinkedList children = new LinkedList();
    private BranchedCommandQueueNode next;
    private BranchedCommandQueueNode previous;
    private boolean m_isBookmark = false;
    private int id;
    private boolean visited = false;
    private boolean firstInBranch = false;
    private boolean lastInBranch = false;
    private boolean inCurrentBranch = false;

    public BranchedCommandQueueNode(Command cmd, BranchedCommandQueueNode parent, BranchedCommandQueueNode prev, int id) {
        this.command = cmd;
        this.parent = parent;
        this.id = id;
        if (prev != null) {
            prev.setNext(this);
            this.previous = prev;
        }
    }

    public BranchedCommandQueueNode createChild(Command cmd, BranchedCommandQueueNode previous, int id) {
        BranchedCommandQueueNode newNode = new BranchedCommandQueueNode(cmd, this, previous, id);
        this.children.add(newNode);
        return newNode;
    }

    public void replaceWith(BranchedCommandQueueNode newNode) {
        int thisIndex = this.parent.children.indexOf(this);
        if (thisIndex == -1) {
            System.out.println("BranchedCommandQueueNode.replaceWith(): error");
            return;
        }
        this.parent.children.remove(thisIndex);
        this.parent.children.add(thisIndex, newNode);
        if (this.parent.next == this) {
            this.parent.next = newNode;
        }
        newNode.parent = this.parent;
        newNode.previous = this.previous;
        this.parent = null;
        this.previous = null;
    }

    public void setIsBookmark(boolean isBookmark) {
        this.m_isBookmark = isBookmark;
    }

    public boolean getIsBookmark() {
        return this.m_isBookmark;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isFirstInBranch() {
        return this.firstInBranch;
    }

    public void setIsFirstInBranch() {
        this.firstInBranch = true;
    }

    public void unsetIsFirstInBranch() {
        this.firstInBranch = false;
    }

    public boolean isLastInBranch() {
        return this.lastInBranch;
    }

    public void setIsLastInBranch() {
        this.lastInBranch = true;
    }

    public void unsetIsLastInBranch() {
        this.lastInBranch = false;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public void setVisited() {
        this.visited = true;
    }

    public boolean isInCurrentBranch() {
        return this.inCurrentBranch;
    }

    public void setInCurrentBranch() {
        this.inCurrentBranch = true;
    }

    public void clearMarkings() {
        this.visited = false;
        this.firstInBranch = false;
        this.lastInBranch = false;
        this.inCurrentBranch = false;
    }

    public Command getCommand() {
        return this.command;
    }

    public int getId() {
        return this.id;
    }

    public BranchedCommandQueueNode getParent() {
        return this.parent;
    }

    public BranchedCommandQueueNode getFirstChild() {
        return (BranchedCommandQueueNode)this.children.getFirst();
    }

    public LinkedList getPathToChild(BranchedCommandQueueNode childNode) {
        if (this == childNode) {
            LinkedList result = new LinkedList();
            return result;
        }
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            BranchedCommandQueueNode directChildNode = (BranchedCommandQueueNode)it.next();
            LinkedList subPath = directChildNode.getPathToChild(childNode);
            if (subPath == null) continue;
            subPath.addFirst(directChildNode);
            return subPath;
        }
        return null;
    }

    public BranchedCommandQueueNode getNext() {
        return this.next;
    }

    public void setNext(BranchedCommandQueueNode next) {
        this.next = next;
    }

    public BranchedCommandQueueNode getPrevious() {
        return this.previous;
    }

    public LinkedList getOldBranches() {
        if (this.children.size() <= 1) {
            return null;
        }
        LinkedList branches = (LinkedList)this.children.clone();
        branches.remove(this.getNext());
        return branches;
    }

    public boolean hasAsChild(BranchedCommandQueueNode u) {
        if (this == u) {
            return true;
        }
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            BranchedCommandQueueNode child = (BranchedCommandQueueNode)it.next();
            if (!child.hasAsChild(u)) continue;
            return true;
        }
        return false;
    }

    public synchronized LinkedList[] getCommonAncestorPaths(BranchedCommandQueueNode node) {
        LinkedList[] result = new LinkedList[2];
        LinkedList downPath = this.getPathToChild(node);
        if (downPath != null) {
            result[0] = null;
            result[1] = downPath;
            return result;
        }
        if (this.parent == null) {
            result[0] = null;
            result[1] = null;
            return result;
        }
        downPath = this.parent.getPathToChild(node);
        if (downPath != null) {
            result[1] = downPath;
            LinkedList<BranchedCommandQueueNode> upPath = new LinkedList<BranchedCommandQueueNode>();
            upPath.add(this);
            result[0] = upPath;
            return result;
        }
        result = this.parent.getCommonAncestorPaths(node);
        if (result == null || result[0] == null) {
            System.out.println("Warning: No Common Ancestor Path, but there should be! Is Node null?" + (node == null));
        } else {
            result[0].addFirst(this);
        }
        return result;
    }

    public void dump(int indent, boolean recurse) {
        String spacer = "";
        int i = 0;
        while (i < indent) {
            spacer = String.valueOf(spacer) + " ";
            ++i;
        }
        String commandName = this.command != null ? this.command.getPresentationName() : "No command!";
        if (this.isLeaf()) {
            System.out.println(String.valueOf(spacer) + this.id + ": Leaf node (cmd " + commandName + ")");
        } else {
            String type = this.isRoot() ? "Root" : "Internal";
            System.out.println(String.valueOf(spacer) + this.id + ": " + type + " node with " + this.children.size() + " children (cmd " + commandName + ")");
            if (recurse) {
                Iterator it = this.children.iterator();
                while (it.hasNext()) {
                    BranchedCommandQueueNode child = (BranchedCommandQueueNode)it.next();
                    child.dump(indent + 2, true);
                }
            }
        }
    }
}

