/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.command;

import edu.berkeley.guir.lib.debugging.Debug;
import edu.berkeley.guir.lib.satin.command.BranchedCommandQueueNode;
import edu.berkeley.guir.lib.satin.command.Command;
import edu.berkeley.guir.lib.satin.command.CommandQueue;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.undo.UndoManager;

public class BranchedCommandQueue
extends UndoManager
implements CommandQueue {
    private BranchedCommandQueueNode historyRoot;
    private BranchedCommandQueueNode currentNode;
    private BranchedCommandQueueNode lastAddedNode;
    private static int counter = 1;

    public BranchedCommandQueue() {
        this.clear();
    }

    public synchronized void clear() {
        this.historyRoot = new BranchedCommandQueueNode(null, null, null, 0);
        this.historyRoot.setVisited();
        this.currentNode = this.historyRoot;
        this.lastAddedNode = this.historyRoot;
    }

    public synchronized void doCommand(Command cmd) {
        BranchedCommandQueueNode newNode;
        int id = counter++;
        this.lastAddedNode = newNode = this.currentNode.createChild(cmd, this.lastAddedNode, id);
        this.currentNode = newNode;
        cmd.execute();
    }

    public void undo() {
        if (this.currentNode.isRoot()) {
            System.out.println("can't undo!");
        } else {
            BranchedCommandQueueNode node = this.currentNode;
            this.currentNode = this.currentNode.getParent();
            Command cmd = node.getCommand();
            cmd.undo();
        }
    }

    public void redo() {
        if (this.currentNode.isLeaf()) {
            System.out.println("can't redo!");
        } else {
            this.currentNode = this.currentNode.getFirstChild();
            Command cmd = this.currentNode.getCommand();
            if (cmd != null) {
                cmd.redo();
            } else {
                System.out.println("cmd null");
            }
        }
    }

    public synchronized Command getLastCommand() {
        return this.currentNode.getCommand();
    }

    public synchronized BranchedCommandQueueNode getLastNode() {
        return this.currentNode;
    }

    public synchronized void jumpTo(BranchedCommandQueueNode node) {
        System.out.println("------------ jumpTo:");
        LinkedList[] paths = this.currentNode.getCommonAncestorPaths(node);
        LinkedList upPath = paths[0];
        LinkedList downPath = paths[1];
        if (upPath != null || downPath != null) {
            BranchedCommandQueueNode nextNode;
            Iterator it;
            if (upPath != null) {
                it = upPath.iterator();
                while (it.hasNext()) {
                    nextNode = (BranchedCommandQueueNode)it.next();
                    System.out.println("Undoing: ");
                    nextNode.getCommand().undo();
                }
            }
            if (downPath != null) {
                it = downPath.iterator();
                while (it.hasNext()) {
                    nextNode = (BranchedCommandQueueNode)it.next();
                    System.out.println("Redoing: ");
                    nextNode.getCommand().redo();
                }
            }
            this.currentNode = node;
        } else {
            Debug.println("Error in BranchedCommandQueue.jumpTo: no LCA was found!");
        }
        Debug.println("------------ jumpTo done");
    }

    public Iterator currentBranchIterator() {
        LinkedList<BranchedCommandQueueNode> nodes = new LinkedList<BranchedCommandQueueNode>();
        BranchedCommandQueueNode next = this.currentNode;
        while (next != null) {
            nodes.addFirst(next);
            next = next.getParent();
        }
        nodes.removeFirst();
        return nodes.iterator();
    }

    public Iterator getIteratorFromParentToChild(BranchedCommandQueueNode parent, BranchedCommandQueueNode child) {
        LinkedList path = parent.getPathToChild(child);
        if (path != null) {
            path.addFirst(parent);
            return path.iterator();
        }
        System.out.println("ERROR: No valid path from " + parent.getId() + ", to child " + child.getId() + ". Are they in the same branch?");
        return null;
    }

    public synchronized Iterator getChronologicalIterator(BranchedCommandQueueNode currentBranchNode) {
        if (currentBranchNode == null) {
            currentBranchNode = this.currentNode;
        }
        LinkedList<BranchedCommandQueueNode> nodes = new LinkedList<BranchedCommandQueueNode>();
        BranchedCommandQueueNode current = this.historyRoot.getNext();
        while (current != null) {
            nodes.addFirst(current);
            current.clearMarkings();
            current = current.getNext();
        }
        BranchedCommandQueueNode newestUncolored = this.markBranch(nodes.iterator(), currentBranchNode);
        while (newestUncolored != null) {
            newestUncolored = this.markBranch(nodes.iterator(), currentBranchNode);
        }
        nodes = new LinkedList();
        current = this.historyRoot.getNext();
        while (current != null) {
            nodes.add(current);
            current = current.getNext();
        }
        if (!nodes.isEmpty()) {
            ((BranchedCommandQueueNode)nodes.getFirst()).unsetIsFirstInBranch();
            ((BranchedCommandQueueNode)nodes.getLast()).unsetIsLastInBranch();
        }
        return nodes.iterator();
    }

    private BranchedCommandQueueNode markBranch(Iterator it, BranchedCommandQueueNode currentBranchNode) {
        BranchedCommandQueueNode newestUncolored = null;
        boolean cont = true;
        while (it.hasNext() && cont) {
            BranchedCommandQueueNode node = (BranchedCommandQueueNode)it.next();
            if (node.isVisited()) continue;
            newestUncolored = node;
            newestUncolored.setIsLastInBranch();
            cont = false;
        }
        if (newestUncolored != null) {
            BranchedCommandQueueNode current = newestUncolored;
            boolean markInCurrentBranch = false;
            cont = true;
            while (current != null && cont) {
                current.setVisited();
                if (current == currentBranchNode) {
                    markInCurrentBranch = true;
                }
                if (markInCurrentBranch) {
                    current.setInCurrentBranch();
                }
                if (current.getParent().isVisited()) {
                    current.setIsFirstInBranch();
                    cont = false;
                    continue;
                }
                current = current.getParent();
            }
        }
        return newestUncolored;
    }

    public void dump() {
        System.out.println("All commands (in tree order):");
        this.historyRoot.dump(2, true);
        System.out.println("All commands (in chronological order):");
        this.dumpChronologically();
        System.out.println("Current command:");
        this.currentNode.dump(2, false);
    }

    public void dumpChronologically() {
        System.out.print("  ");
        StringBuffer currentBranch = new StringBuffer();
        Iterator it = this.getChronologicalIterator(null);
        while (it.hasNext()) {
            BranchedCommandQueueNode node = (BranchedCommandQueueNode)it.next();
            if (node.isFirstInBranch()) {
                System.out.print("( ");
            }
            System.out.print(String.valueOf(node.getId()) + " ");
            if (node.isLastInBranch()) {
                System.out.print(") ");
            }
            if (!node.isInCurrentBranch()) continue;
            currentBranch.append(String.valueOf(node.getId()) + " ");
        }
        System.out.println("\nCurrent branch:\n  " + currentBranch);
    }
}

