/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.command;

import edu.berkeley.guir.lib.satin.command.CommandImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import java.awt.geom.AffineTransform;

public class ApplyTransformationCommand
extends CommandImpl {
    static final long serialVersionUID = 8262462120980641777L;
    GraphicalObject gob;
    AffineTransform tx;
    AffineTransform oldTx;

    public ApplyTransformationCommand(GraphicalObject gob, AffineTransform tx) {
        this.gob = gob;
        this.tx = tx;
    }

    public String getPresentationName() {
        return "Apply Transformation to Graphical Object";
    }

    public boolean canRedo() {
        return true;
    }

    public boolean canUndo() {
        return true;
    }

    public boolean isSignificant() {
        return true;
    }

    public void run() {
        this.oldTx = this.gob.getTransform(11);
        this.gob.applyTransform(this.tx);
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        this.gob.setTransform(this.oldTx);
    }

    public void die() {
    }
}

