/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin;

import edu.berkeley.guir.lib.awt.geom.AffineTransformLib;
import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.berkeley.guir.lib.debugging.Debug;
import edu.berkeley.guir.lib.satin.RenderChecker;
import edu.berkeley.guir.lib.satin.RenderServer;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.command.CopyCommand;
import edu.berkeley.guir.lib.satin.command.CutCommand;
import edu.berkeley.guir.lib.satin.command.DeleteCommand;
import edu.berkeley.guir.lib.satin.command.InsertCommand;
import edu.berkeley.guir.lib.satin.command.PasteCommand;
import edu.berkeley.guir.lib.satin.event.BasicStrokeEventFilter;
import edu.berkeley.guir.lib.satin.event.NewStrokeEvent;
import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.event.StrokeEventFilter;
import edu.berkeley.guir.lib.satin.event.StrokeListener;
import edu.berkeley.guir.lib.satin.event.UpdateStrokeEvent;
import edu.berkeley.guir.lib.satin.graphics.SatinGraphics;
import edu.berkeley.guir.lib.satin.interpreter.Interpreter;
import edu.berkeley.guir.lib.satin.objects.GObJComponentWrapper;
import edu.berkeley.guir.lib.satin.objects.GlobalID;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectCollection;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectCollectionImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectGroup;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectGroupImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectLib;
import edu.berkeley.guir.lib.satin.objects.Style;
import edu.berkeley.guir.lib.satin.objects.SwingPeer;
import edu.berkeley.guir.lib.satin.stroke.StrokeAssembler;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import edu.berkeley.guir.lib.satin.view.View;
import edu.berkeley.guir.lib.satin.watch.Watchable;
import edu.berkeley.guir.lib.satin.watch.WatchableImpl;
import edu.berkeley.guir.lib.satin.watch.Watcher;
import edu.berkeley.guir.lib.util.ParserLib;
import edu.berkeley.guir.lib.util.StringLib;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class Sheet
extends JPanel
implements GraphicalObjectGroup,
SatinConstants,
GraphicalObjectCollection,
GraphicalObject,
Watchable,
Watcher,
Shape,
StrokeListener {
    static final long serialVersionUID = 8577810670053556841L;
    private static boolean isIdleRenderingMode = false;
    protected RenderServer renderServer = null;
    protected Timer renderTimer = null;
    protected int bufferedRenderRequests = 0;
    private boolean isManageSwingPeer = false;
    private BufferedImage sBufferedImage = null;
    private boolean isSDoublebufferEnabled = true;
    private boolean isFirstRender = true;
    private boolean shouldRenderToScreen = true;
    private boolean isPanning = false;
    public static final int paintNotStarted = 0;
    public static final int painting = 1;
    public static final int paintJustFinished = 2;
    private int paintProcess = 0;
    public static String BACKGROUND_COLOR_PROPERTY = "BACKGROUND_COLOR_PROPERTY";
    public static String BACKGROUND_COLOR_DEFAULT = "204, 204, 204";
    public static String LEFTSTROKE_STYLE_FILE = "LeftStroke.properties";
    public static String RIGHTSTROKE_STYLE_FILE = "RightStroke.properties";
    protected StrokeAssembler asm;
    protected TimedStroke currentStk;
    protected Style leftStyle;
    protected float leftLineWidth;
    protected Style rightStyle;
    protected float rightLineWidth;
    protected boolean flagDrawCurrent;
    protected boolean flagDamage;
    protected SheetGraphicalObjectGroup gobs;
    protected Style selectedStyle;
    protected Watchable watchable;
    protected StrokeEventFilter drawFilter;
    protected StrokeEventFilter addFilter;
    protected transient int damageCount = 0;
    protected transient SatinGraphics graphics = new SatinGraphics();
    protected GraphicalObject GOBWithFocus;
    protected JComponent swingWrapper = new JComponent(){};
    protected DenimRepaintManager repaintManager;
    protected boolean keepJavaAntialiasing = false;
    private GlobalID globalID = null;
    static Rectangle repaintRect;

    static {
        SatinConstants.glprops.setProperty("SATIN_DATA_DIRECTORY_GPROPERTY", "data/");
        SatinConstants.glprops.setProperty(BACKGROUND_COLOR_PROPERTY, BACKGROUND_COLOR_DEFAULT);
        repaintRect = new Rectangle();
    }

    protected synchronized void undoInternal() {
        try {
            SatinConstants.cmdqueue.undo();
        }
        catch (CannotUndoException e) {
            JOptionPane.showMessageDialog(this, "Beginning of history: nothing to undo", "Error during undo", 0);
        }
    }

    protected synchronized void redoInternal() {
        try {
            SatinConstants.cmdqueue.redo();
        }
        catch (CannotRedoException e) {
            JOptionPane.showMessageDialog(this, "End of history: nothing to redo", "Error during redo", 0);
        }
    }

    protected void pasteInternal() {
        SatinConstants.cmdqueue.doCommand(new PasteCommand(this));
    }

    protected void cutInternal() {
        Iterator it = SatinConstants.cmdsubsys.getSelected();
        SatinConstants.cmdqueue.doCommand(new CutCommand(it));
    }

    protected void copyInternal() {
        Iterator it = SatinConstants.cmdsubsys.getSelected();
        SatinConstants.cmdqueue.doCommand(new CopyCommand(it));
    }

    protected void deleteInternal() {
        Iterator it = SatinConstants.cmdsubsys.getSelected();
        SatinConstants.cmdqueue.doCommand(new DeleteCommand(it));
    }

    public Sheet() {
        this.renderServer = new RenderServer(this);
        SatinConstants.cmdsubsys.initializeCommandSubsystem(this);
        SatinConstants.cmdsubsys.addWatcher(this);
        SatinConstants.cmdsubsys.clearSelected();
        this.gobs = new SheetGraphicalObjectGroup();
        this.setSize(this.getBounds().width, this.getBounds().height);
        this.asm = new StrokeAssembler(this);
        this.addMouseListener(new InternalMouseListener());
        this.addKeyListener(new InternalKeyListener());
        this.setLeftCurrentStyle(new Style(LEFTSTROKE_STYLE_FILE, new TimedStroke().getStyle()));
        this.setRightCurrentStyle(new Style(RIGHTSTROKE_STYLE_FILE, new TimedStroke().getStyle()));
        this.selectedStyle = new Style();
        this.selectedStyle.setDrawColor(Color.black);
        this.selectedStyle.setFillColor(Color.black);
        this.watchable = new WatchableImpl();
        this.setDoubleBuffered(false);
        this.addMouseListener(new InternalMouseListener());
        this.flagDamage = true;
        this.drawFilter = new BasicStrokeEventFilter();
        this.addFilter = new BasicStrokeEventFilter();
        try {
            String strColor = (String)SatinConstants.glprops.getProperty(BACKGROUND_COLOR_PROPERTY);
            Color bkgrdColor = ParserLib.parseColor(strColor);
            this.setBackground(bkgrdColor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TimedStroke.setDrawFix(true);
        this.requestFocus();
        this.GOBWithFocus = null;
        this.swingWrapper.setVisible(true);
        this.swingWrapper.setSize(0, 0);
        this.add(this.swingWrapper);
        this.repaintManager = new DenimRepaintManager();
    }

    public Sheet(int w, int h) {
        this();
        this.setBoundingPoints2D(10, new Rectangle(0, 0, w, h));
    }

    public Sheet(Dimension dim) {
        this(dim.width, dim.height);
    }

    public void setSheet(Sheet sheet) {
        this.asm = sheet.asm;
        this.leftStyle = sheet.leftStyle;
        this.rightStyle = sheet.rightStyle;
        this.leftLineWidth = sheet.leftLineWidth;
        this.rightLineWidth = sheet.rightLineWidth;
        this.selectedStyle = sheet.selectedStyle;
        this.watchable = sheet.watchable;
        Iterator it = sheet.gobs.getForwardIterator();
        int size = sheet.gobs.numElements();
        Object[] objs = new Object[size];
        int i = 0;
        this.gobs.clear();
        while (it.hasNext()) {
            objs[i] = it.next();
            ++i;
        }
        i = 0;
        while (i < size) {
            this.gobs.addToBack((GraphicalObject)objs[i]);
            ++i;
        }
        this.damage(21);
    }

    public void setRepaintManager() {
        RepaintManager.setCurrentManager(this.repaintManager);
    }

    public void addToSwingWrapper(GraphicalObject gob) {
        this.swingWrapper.add(((GObJComponentWrapper)gob).getComponent());
    }

    public void deleteFromSwingWrapper(GraphicalObject gob) {
        this.swingWrapper.remove(((GObJComponentWrapper)gob).getComponent());
    }

    public void setResizeMode(int m) {
        this.gobs.setResizeMode(m);
    }

    public int getResizeMode() {
        return this.gobs.getResizeMode();
    }

    public void setGobWithFocus(GraphicalObject g) {
        if (g != null) {
            this.GOBWithFocus = g;
            ((GObJComponentWrapper)this.GOBWithFocus).getComponent().requestFocus();
        }
    }

    private void setGobWithFocus(Point pt) {
        this.GOBWithFocus = null;
        GraphicalObjectCollectionImpl gobcol = new GraphicalObjectCollectionImpl();
        this.getGraphicalObjects(12, pt, 30, 41, 52, 1.0, (GraphicalObjectCollection)gobcol);
        Iterator it = gobcol.getForwardIterator();
        GraphicalObject gob = null;
        float gobDist = Float.MAX_VALUE;
        while (it.hasNext()) {
            float dist;
            gob = (GraphicalObject)it.next();
            if (!gob.isVisible() || !(gob instanceof GObJComponentWrapper) || !((dist = gob.minDistance(12, pt)) < gobDist)) continue;
            gobDist = dist;
            this.GOBWithFocus = gob;
        }
        if (this.GOBWithFocus != null) {
            ((GObJComponentWrapper)this.GOBWithFocus).getComponent().requestFocus();
        }
    }

    public GraphicalObject getGobWithFocus() {
        return this.GOBWithFocus;
    }

    public void setAutoScroll(boolean flag) {
        this.asm.setAutoScroll(flag);
    }

    public void setEnabled(boolean flag) {
        this.asm.setEnabled(flag);
    }

    public boolean isEnabled() {
        return this.asm.isEnabled();
    }

    public void setAcceptLeftButton(boolean flag) {
        this.asm.setAcceptLeftButton(flag);
    }

    public void setAcceptMiddleButton(boolean flag) {
        this.asm.setAcceptMiddleButton(flag);
    }

    public void setAcceptRightButton(boolean flag) {
        this.asm.setAcceptRightButton(flag);
    }

    public void setDrawLeftButtonStrokes(boolean flag) {
        this.drawFilter.setAcceptLeftButton(flag);
    }

    public void setDrawMiddleButtonStrokes(boolean flag) {
        this.drawFilter.setAcceptMiddleButton(flag);
    }

    public void setDrawRightButtonStrokes(boolean flag) {
        this.drawFilter.setAcceptRightButton(flag);
    }

    public void setAddLeftButtonStrokes(boolean flag) {
        this.addFilter.setAcceptLeftButton(flag);
    }

    public void setAddMiddleButtonStrokes(boolean flag) {
        this.addFilter.setAcceptMiddleButton(flag);
    }

    public void setAddRightButtonStrokes(boolean flag) {
        this.addFilter.setAcceptRightButton(flag);
    }

    public int getUniqueID() {
        return this.gobs.getUniqueID();
    }

    public void setUniqueID(int newID) {
        this.gobs.setUniqueID(newID);
    }

    public Iterator getPropertyNames() {
        return this.gobs.getPropertyNames();
    }

    public Object getProperty(String strPropertyName) {
        return this.gobs.getProperty(strPropertyName);
    }

    public void setProperty(String strPropertyName, Object newVal) {
        this.gobs.setProperty(strPropertyName, newVal);
    }

    public Object removeProperty(String strPropertyName) {
        return this.gobs.removeProperty(strPropertyName);
    }

    public List getIndexedProperty(String strPropertyName) {
        return this.gobs.getIndexedProperty(strPropertyName);
    }

    public Object getIndexedProperty(String strPropertyName, int index) {
        return this.gobs.getIndexedProperty(strPropertyName, index);
    }

    public void setIndexedProperty(String strPropertyName, int index, Object newVal) {
        this.gobs.setIndexedProperty(strPropertyName, index, newVal);
    }

    public void addIndexedProperty(String strPropertyName, Object newVal) {
        this.gobs.addIndexedProperty(strPropertyName, newVal);
    }

    public Object removeIndexedProperty(String strPropertyName, int index) {
        return this.gobs.removeIndexedProperty(strPropertyName, index);
    }

    public List removeIndexedProperty(String strPropertyName) {
        return this.gobs.removeIndexedProperty(strPropertyName);
    }

    public void clearIndexedProperty(String strPropertyName) {
        this.gobs.clearIndexedProperty(strPropertyName);
    }

    public View getView() {
        return this.gobs.getView();
    }

    public void setView(View v) {
        this.gobs.setView(v);
    }

    public void setMangeSwingPeer(boolean b) {
        this.isManageSwingPeer = b;
    }

    public Interpreter getGestureInterpreter() {
        return this.gobs.getGestureInterpreter();
    }

    public Interpreter setGestureInterpreter(Interpreter intrp) {
        return this.gobs.setGestureInterpreter(intrp);
    }

    public Interpreter getInkInterpreter() {
        return this.gobs.getInkInterpreter();
    }

    public Interpreter setInkInterpreter(Interpreter intrp) {
        return this.gobs.setInkInterpreter(intrp);
    }

    public Style setStyle(Style newStyle) {
        return this.gobs.setStyle(newStyle);
    }

    public Style getStyle() {
        return this.gobs.getStyle();
    }

    public Style getStyleRef() {
        return this.gobs.getStyleRef();
    }

    public void setLeftCurrentStyle(Style newStyle) {
        this.leftStyle = (Style)newStyle.clone();
        this.leftLineWidth = this.leftStyle.getLineWidth();
    }

    public Style getLeftCurrentStyle() {
        return (Style)this.leftStyle.clone();
    }

    public void setRightCurrentStyle(Style newStyle) {
        this.rightStyle = (Style)newStyle.clone();
        this.rightLineWidth = this.rightStyle.getLineWidth();
    }

    public Style getRightCurrentStyle() {
        return (Style)this.rightStyle.clone();
    }

    public Style setSelectedStyle(Style newStyle) {
        this.selectedStyle = (Style)newStyle.clone();
        return newStyle;
    }

    public Style getSelectedStyle() {
        return (Style)this.selectedStyle.clone();
    }

    public int getRelativeLayer() {
        return this.gobs.getRelativeLayer();
    }

    public void setRelativeLayer(int layer) {
        this.gobs.setRelativeLayer(layer);
    }

    public List getAbsoluteLayer() {
        return this.gobs.getAbsoluteLayer();
    }

    public void bringUpALayer() {
        this.gobs.bringUpALayer();
    }

    public void bringDownALayer() {
        this.gobs.bringDownALayer();
    }

    public void bringToTopLayer() {
        this.gobs.bringToTopLayer();
    }

    public void bringToBottomLayer() {
        this.gobs.bringToBottomLayer();
    }

    public void applyTransform(AffineTransform tr) {
        this.gobs.applyTransform(tr);
    }

    public void setTransform(AffineTransform tr) {
        this.gobs.setTransform(tr);
    }

    public AffineTransform getTransformRef() {
        return this.gobs.getTransformRef();
    }

    public AffineTransform getTransform(int cdsys) {
        return this.gobs.getTransform(cdsys);
    }

    public AffineTransform getTransform(int cdsys, AffineTransform outTx) {
        return this.gobs.getTransform(cdsys, outTx);
    }

    public AffineTransform getInverseTransform(int cdsys) {
        return this.gobs.getInverseTransform(cdsys);
    }

    public AffineTransform getInverseTransform(int cdsys, AffineTransform tx) {
        return this.gobs.getInverseTransform(cdsys, tx);
    }

    public void setHasClosedBoundingPoints(boolean flag) {
    }

    public boolean hasClosedBoundingPoints() {
        return true;
    }

    public float minDistance(int cdsys, double x, double y) {
        return this.gobs.minDistance(cdsys, x, y);
    }

    public float minDistance(int cdsys, Point2D pt) {
        return this.gobs.minDistance(cdsys, pt);
    }

    public Point2D getLocation2D(int cdsys) {
        return this.gobs.getLocation2D(cdsys);
    }

    public Point2D getLocation2D(int cdsys, AffineTransform tx, Point2D pt) {
        return this.gobs.getLocation2D(cdsys, tx, pt);
    }

    public Rectangle2D getBounds2D(int cdsys) {
        return this.gobs.getBounds2D(cdsys);
    }

    public Rectangle2D getBounds2D(int cdsys, AffineTransform tx, Rectangle2D rect) {
        return this.gobs.getBounds2D(cdsys, tx, rect);
    }

    public Polygon2D getBoundingPoints2D(int cdsys) {
        return this.gobs.getBoundingPoints2D(cdsys);
    }

    public Polygon2D getBoundingPoints2D(int cdsys, AffineTransform tx, Polygon2D poly) {
        return this.gobs.getBoundingPoints2D(cdsys, tx, poly);
    }

    public float getWidth2D(int cdsys) {
        return this.gobs.getWidth2D(cdsys);
    }

    public float getHeight2D(int cdsys) {
        return this.gobs.getHeight2D(cdsys);
    }

    public boolean shapeContains(GraphicalObject gob) {
        return true;
    }

    public boolean shapeContains(int cdsys, Point2D pt) {
        return true;
    }

    public boolean shapeContains(int cdsys, double x, double y) {
        return true;
    }

    public boolean shapeContains(int cdsys, Shape s) {
        return true;
    }

    public boolean shapeIntersects(GraphicalObject gob) {
        return true;
    }

    public boolean shapeIntersects(int cdsys, Shape s) {
        return true;
    }

    public boolean isSelectable() {
        return false;
    }

    public void setSelectable(boolean flag) {
    }

    public void moveTo(int cdsys, double x, double y) {
        this.gobs.moveTo(cdsys, x, y);
    }

    public void moveTo(int cdsys, double x, double y, double theta) {
        System.out.println("Sheet man, you cain't rotate me!");
    }

    public void moveTo(int cdsys, Point2D pt) {
        this.gobs.moveTo(cdsys, pt);
    }

    public void moveBy(int cdsys, double dx, double dy) {
        this.gobs.moveBy(cdsys, dx, dy);
    }

    public void moveBy(int cdsys, Point2D pt) {
        this.gobs.moveBy(cdsys, pt);
    }

    public void setBoundingPoints2D(int cdsys, Shape s) {
        this.gobs.setBoundingPoints2D(cdsys, s);
    }

    public boolean contains(double x, double y) {
        return true;
    }

    public boolean contains(double x, double y, double w, double h) {
        return true;
    }

    public boolean contains(Point2D p) {
        return true;
    }

    public boolean contains(Rectangle2D r) {
        return true;
    }

    public Rectangle2D getBounds2D() {
        return this.getBounds();
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return this.gobs.getPathIterator(at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.gobs.getPathIterator(at, flatness);
    }

    public boolean intersects(double x, double y, double w, double h) {
        return true;
    }

    public boolean intersects(Rectangle2D r) {
        return true;
    }

    public void onNewStroke(NewStrokeEvent evt) {
        if (this.renderTimer != null) {
            this.renderTimer.cancel();
            this.renderTimer = null;
        }
        evt.appendDispatchee(this.gobs);
        this.flagDrawCurrent = true;
        this.currentStk = evt.getStroke();
        this.currentStk.setParentGroup(this);
        this.gobs.onNewStroke(evt);
        this.flagDrawCurrent = evt.shouldRender() && this.drawFilter.isEventAccepted(evt);
    }

    public void preProcessNewStroke(NewStrokeEvent evt) {
        this.gobs.superPreProcessNewStroke(evt);
    }

    public void redispatchNewStroke(NewStrokeEvent evt) {
        this.gobs.superRedispatchNewStroke(evt);
    }

    public void postProcessNewStroke(NewStrokeEvent evt) {
        this.gobs.superPostProcessNewStroke(evt);
    }

    public void handleNewStroke(NewStrokeEvent evt) {
        this.gobs.superHandleNewStroke(evt);
    }

    public void onUpdateStroke(UpdateStrokeEvent evt) {
        this.currentStk = evt.getStroke();
        this.gobs.onUpdateStroke(evt);
        this.flagDrawCurrent = evt.shouldRender() && this.drawFilter.isEventAccepted(evt);
    }

    public void preProcessUpdateStroke(UpdateStrokeEvent evt) {
        this.gobs.superPreProcessUpdateStroke(evt);
    }

    public void redispatchUpdateStroke(UpdateStrokeEvent evt) {
        this.gobs.superRedispatchUpdateStroke(evt);
    }

    public void postProcessUpdateStroke(UpdateStrokeEvent evt) {
        this.gobs.superPostProcessUpdateStroke(evt);
    }

    public void handleUpdateStroke(UpdateStrokeEvent evt) {
        this.gobs.superHandleUpdateStroke(evt);
    }

    public void onSingleStroke(SingleStrokeEvent evt) {
        this.currentStk = evt.getStroke();
        Rectangle rect = GraphicalObjectLib.getRenderBounds(this.currentStk);
        this.currentStk = null;
        this.gobs.onSingleStroke(evt);
        boolean bl = this.flagDrawCurrent = evt.shouldRender() && this.drawFilter.isEventAccepted(evt);
        if (isIdleRenderingMode) {
            this.damage(22, rect);
        } else {
            this.damage(21, rect);
        }
        if (this.renderTimer == null) {
            this.renderTimer = new Timer();
            this.renderTimer.schedule((TimerTask)new RenderChecker(this), RenderServer.optimizedInterval);
        }
    }

    public TimedStroke getCurrentStroke() {
        return this.currentStk;
    }

    public void clearCurrentStroke() {
        this.currentStk = null;
    }

    public void preProcessSingleStroke(SingleStrokeEvent evt) {
        this.gobs.superPreProcessSingleStroke(evt);
    }

    public void redispatchSingleStroke(SingleStrokeEvent evt) {
        this.gobs.superRedispatchSingleStroke(evt);
    }

    public void postProcessSingleStroke(SingleStrokeEvent evt) {
        this.gobs.superPostProcessSingleStroke(evt);
    }

    public void handleSingleStroke(SingleStrokeEvent evt) {
        TimedStroke stk = evt.getStroke();
        if (stk.getLength2D(12) < 10.0) {
            return;
        }
        if (!this.addFilter.isEventAccepted(evt)) {
            return;
        }
        SatinConstants.cmdqueue.doCommand(new InsertCommand(this, stk));
    }

    public void bufferUpcomingRender(int count) {
        if (count <= 0) {
            return;
        }
        this.bufferedRenderRequests = count;
    }

    public void flushRenderRequests() {
        this.renderServer.flush(21);
        this.bufferedRenderRequests = 0;
    }

    public void setFlushSpeed(double p) {
        this.renderServer.setFlushSpeed(p);
    }

    public static boolean isIdleRenderingMode() {
        return isIdleRenderingMode;
    }

    public static void setIdleRenderingMode(boolean b) {
        isIdleRenderingMode = b;
    }

    public void enableRealtimeRender() {
        this.renderServer.startRealtimeRender();
    }

    public void disableRealtimeRender() {
        this.renderServer.endRealtimeRender();
    }

    public void setSheetDoubleBufferEnabled(boolean b) {
        this.isSDoublebufferEnabled = b;
    }

    public boolean isSheetDoubleBufferEnabled() {
        return this.isSDoublebufferEnabled;
    }

    public BufferedImage getBufferedImage() {
        return this.sBufferedImage;
    }

    public boolean isRenderToScreen() {
        return this.shouldRenderToScreen;
    }

    public void setRenderToScreen(boolean toScreen) {
        this.shouldRenderToScreen = toScreen;
        if (toScreen) {
            RepaintManager.currentManager(this).setDoubleBufferingEnabled(true);
        } else {
            RepaintManager.currentManager(this).setDoubleBufferingEnabled(false);
        }
    }

    public void disableDamage() {
        ++this.damageCount;
    }

    public void enableDamage() {
        --this.damageCount;
        if (this.damageCount < 0) {
            throw new RuntimeException("Error - unbalanced number of disable/enable damage calls made");
        }
    }

    public boolean hasDamageEnabled() {
        return this.damageCount <= 0;
    }

    public void setClipToBounds(boolean flag) {
        this.gobs.setClipToBounds(flag);
    }

    public boolean isClippedToBounds() {
        return this.gobs.isClippedToBounds();
    }

    public void damage(int sync) {
        if (!this.hasDamageEnabled()) {
            return;
        }
        this.damage(sync, this);
    }

    public void damage(int sync, Rectangle2D rect) {
        if (!this.hasDamageEnabled()) {
            return;
        }
        Sheet.repaintRect.x = (int)(rect.getX() - 6.0);
        Sheet.repaintRect.y = (int)(rect.getY() - 6.0);
        Sheet.repaintRect.width = (int)(rect.getWidth() + 12.0);
        Sheet.repaintRect.height = (int)(rect.getHeight() + 12.0);
        if (this.bufferedRenderRequests > 0) {
            --this.bufferedRenderRequests;
            this.renderServer.sendARequest(repaintRect, 22);
        } else {
            this.renderServer.sendARequest(repaintRect, sync);
        }
    }

    public void damage(int sync, GraphicalObject gob) {
        if (!this.hasDamageEnabled()) {
            return;
        }
        this.damage(sync, GraphicalObjectLib.getRenderBounds(gob));
    }

    public void damage(int sync, Rectangle2D oldRect, Rectangle2D newRect) {
        if (!this.hasDamageEnabled()) {
            return;
        }
        Rectangle2D.union(oldRect, newRect, oldRect);
        this.damage(sync, oldRect);
    }

    public boolean isSheetPanning() {
        return this.isPanning;
    }

    public void setSheetPanning(boolean b) {
        this.isPanning = b;
    }

    public void setParentGroup(GraphicalObjectGroup newparent) {
        this.gobs.setParentGroup(newparent);
    }

    public GraphicalObjectGroup getParentGroup() {
        return this.gobs.getParentGroup();
    }

    public Sheet getSheet() {
        return this;
    }

    public void initAfterAdd() {
        this.gobs.initAfterAdd();
    }

    public void initAfterAddToSheet() {
        this.gobs.initAfterAddToSheet();
    }

    public void delete() {
    }

    public int getRelativeLayer(GraphicalObject gob) {
        return this.gobs.getRelativeLayer(gob);
    }

    public void setRelativeLayer(GraphicalObject gob, int layer) {
        this.gobs.setRelativeLayer(gob, layer);
    }

    public List getAbsoluteLayer(GraphicalObject gob) {
        return this.gobs.getAbsoluteLayer(gob);
    }

    public void bringUpALayer(GraphicalObject gob) {
        this.gobs.bringUpALayer(gob);
    }

    public void bringUpNLayers(GraphicalObject gob, int n) {
        this.gobs.bringUpNLayers(gob, n);
    }

    public void bringUpNLayers(int n) {
        this.gobs.bringUpNLayers(n);
    }

    public void bringDownALayer(GraphicalObject gob) {
        this.gobs.bringDownALayer(gob);
    }

    public void bringDownNLayers(GraphicalObject gob, int n) {
        this.gobs.bringDownNLayers(gob, n);
    }

    public void bringDownNLayers(int n) {
        this.gobs.bringDownNLayers(n);
    }

    public void bringToTopLayer(GraphicalObject gob) {
        this.gobs.bringToTopLayer(gob);
    }

    public void bringToBottomLayer(GraphicalObject gob) {
        this.gobs.bringToBottomLayer(gob);
    }

    public GraphicalObject add(GraphicalObject gob) {
        return this.gobs.add(gob);
    }

    public GraphicalObject addToBack(GraphicalObject gob) {
        return this.gobs.addToBack(gob);
    }

    public GraphicalObject addToFront(GraphicalObject gob) {
        return this.gobs.addToFront(gob);
    }

    public GraphicalObject add(int index, GraphicalObject gob) {
        return this.gobs.add(index, gob);
    }

    public GraphicalObject add(GraphicalObject gob, int pos) {
        return this.gobs.add(gob, pos);
    }

    public GraphicalObject addToBack(GraphicalObject gob, int pos) {
        return this.gobs.addToBack(gob, pos);
    }

    public GraphicalObject addToFront(GraphicalObject gob, int pos) {
        return this.gobs.addToFront(gob, pos);
    }

    public GraphicalObject add(int index, GraphicalObject gob, int pos) {
        return this.gobs.add(index, gob, pos);
    }

    public void clear() {
        this.gobs.clear();
        SatinConstants.cmdsubsys.clearSelected();
    }

    public boolean contains(GraphicalObject gob) {
        return this.gobs.contains(gob);
    }

    public GraphicalObject get(int index) {
        return this.gobs.get(index);
    }

    public GraphicalObject getFirst() {
        return this.gobs.getFirst();
    }

    public GraphicalObject getLast() {
        return this.gobs.getLast();
    }

    public GraphicalObject getID(int id) {
        if (this.getUniqueID() == id) {
            return this;
        }
        return this.gobs.getID(id);
    }

    public Rectangle2D getCollectionBounds2D(int cdsys) {
        return this.gobs.getCollectionBounds2D(cdsys);
    }

    public Rectangle2D getCollectionBounds2D(int cdsys, Rectangle2D rect) {
        return this.gobs.getCollectionBounds2D(cdsys, rect);
    }

    public int indexOf(GraphicalObject gob) {
        return this.gobs.indexOf(gob);
    }

    public boolean isEmpty() {
        return this.gobs.isEmpty();
    }

    public void sort(Comparator c) {
    }

    public int numElements() {
        return this.gobs.numElements();
    }

    public GraphicalObject remove(GraphicalObject gob) {
        return this.gobs.remove(gob);
    }

    public Iterator getForwardIterator() {
        return this.gobs.getForwardIterator();
    }

    public Iterator getReverseIterator() {
        return this.gobs.getReverseIterator();
    }

    public void removeAll(GraphicalObjectCollection gobcol) {
        this.gobs.removeAll(gobcol);
    }

    public boolean getAllowDeepGet() {
        return this.gobs.getAllowDeepGet();
    }

    public void setAllowDeepGet(boolean flag) {
        this.gobs.setAllowDeepGet(flag);
    }

    public GraphicalObjectCollection getGraphicalObjects(int cdsys, Point2D pt, int num, int depth, int gettype, double thresh, GraphicalObjectCollection out) {
        return this.gobs.getGraphicalObjects(cdsys, pt, num, depth, gettype, thresh, out);
    }

    public GraphicalObjectCollection getGraphicalObjects(int cdsys, double x, double y, int num, int depth, int gettype, double thresh, GraphicalObjectCollection out) {
        return this.gobs.getGraphicalObjects(cdsys, x, y, num, depth, gettype, thresh, out);
    }

    public GraphicalObjectCollection getGraphicalObjects(int cdsys, Shape s, int num, int depth, int gettype, double thresh, GraphicalObjectCollection out) {
        return this.gobs.getGraphicalObjects(cdsys, s, num, depth, gettype, thresh, out);
    }

    public GraphicalObjectCollection getGraphicalObjects(GraphicalObject gob, int num, int depth, int gettype, double thresh, GraphicalObjectCollection out) {
        return this.gobs.getGraphicalObjects(gob, num, depth, gettype, thresh, out);
    }

    public GraphicalObjectCollection getGraphicalObjects(int cdsys, Point2D pt, int num, int depth, int gettype) {
        return this.gobs.getGraphicalObjects(cdsys, pt, num, depth, gettype);
    }

    public GraphicalObjectCollection getGraphicalObjects(int cdsys, double x, double y, int num, int depth, int gettype) {
        return this.gobs.getGraphicalObjects(cdsys, x, y, num, depth, gettype);
    }

    public GraphicalObjectCollection getGraphicalObjects(int cdsys, Shape s, int num, int depth, int gettype) {
        return this.gobs.getGraphicalObjects(cdsys, s, num, depth, gettype);
    }

    public GraphicalObjectCollection getGraphicalObjects(GraphicalObject gob, int num, int depth, int gettype) {
        return this.gobs.getGraphicalObjects(gob, num, depth, gettype);
    }

    public Watcher addWatcher(Watcher w) {
        return this.gobs.addWatcher(w);
    }

    public int countWatchers() {
        return this.gobs.countWatchers();
    }

    public Watcher removeWatcher(Watcher w) {
        return this.gobs.removeWatcher(w);
    }

    public void clearWatchers() {
        this.gobs.clearWatchers();
    }

    public void enableNotify() {
        this.gobs.enableNotify();
    }

    public void disableNotify() {
        this.gobs.disableNotify();
    }

    public boolean hasNotifyEnabled() {
        return this.gobs.hasNotifyEnabled();
    }

    public void notifyWatchers() {
        this.gobs.notifyWatchers(this);
    }

    public void notifyWatchers(Object arg) {
        this.gobs.notifyWatchers(arg);
    }

    public void notifyWatchersUpdate(Object arg) {
        this.gobs.notifyWatchersUpdate(arg);
    }

    public void notifyWatchersUpdate(String strProperty, Object newVal, Object oldVal) {
        this.gobs.notifyWatchersUpdate(strProperty, newVal, oldVal);
    }

    public void notifyWatchersDelete() {
        this.gobs.notifyWatchersDelete();
    }

    public void onNotify(Watchable w, Object arg) {
        this.gobs.superNotify(w, arg);
    }

    public void onUpdate(Watchable w, Object arg) {
        this.gobs.superUpdate(w, arg);
    }

    public void onUpdate(Watchable w, String strProperty, Object oldVal, Object newVal) {
        this.gobs.superUpdate(w, strProperty, oldVal, newVal);
    }

    public void onDelete(Watchable w) {
        this.gobs.superDelete(w);
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.gobs.setBoundingPoints2D(10, this.getBounds());
    }

    public void setSize(Dimension dim) {
        super.setSize(dim);
        this.gobs.setBoundingPoints2D(10, this.getBounds());
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isFocusable() {
        return true;
    }

    public void setBackground(Color bkgrd) {
        super.setBackground(bkgrd);
        if (this.graphics != null) {
            this.graphics.setBackground(bkgrd);
        }
    }

    public void setKeepJavaAntialiasing(boolean flag) {
        this.keepJavaAntialiasing = flag;
    }

    public boolean getSmoothStrokes() {
        return this.asm.getRenderCurvy();
    }

    public void setSmoothStrokes(boolean flag) {
        this.asm.setRenderCurvy(flag);
    }

    public void render(SatinGraphics g) {
        this.gobs.render(g);
    }

    public RenderServer getRenderServer() {
        return this.renderServer;
    }

    private Rectangle getLatestBounds(String id) {
        Iterator it = this.gobs.getForwardIterator();
        while (it.hasNext()) {
            GraphicalObject obj = (GraphicalObject)it.next();
            if (!(obj instanceof SwingPeer) || !((SwingPeer)obj).getName().equals(id)) continue;
            return ((SwingPeer)obj).getLatestBounds();
        }
        return null;
    }

    private void paintSwingPeerComponent(Graphics g) {
        this.paintChildren(g);
    }

    public void paint(Graphics g) {
        if (this.isFirstRender) {
            this.sBufferedImage = (BufferedImage)this.createImage(this.getWidth(), this.getHeight());
            this.isFirstRender = false;
        }
        if (this.getWidth() != this.sBufferedImage.getWidth() || this.getHeight() != this.sBufferedImage.getHeight()) {
            this.sBufferedImage = (BufferedImage)this.createImage(this.getWidth(), this.getHeight());
            this.renderServer.sceneGraphChanged = true;
        }
        Graphics myg = g;
        if (this.isSDoublebufferEnabled && this.sBufferedImage != null) {
            myg = this.sBufferedImage.createGraphics();
            myg.setClip(g.getClip());
        }
        if (this.renderServer.sceneGraphChanged) {
            this.paintComponent(myg);
            this.renderServer.sceneGraphChanged = false;
            if (this.isManageSwingPeer) {
                this.paintSwingPeerComponent(myg);
            }
        }
        if (!this.isManageSwingPeer) {
            this.paintChildren(myg);
        }
        if (this.isSDoublebufferEnabled && this.sBufferedImage != null && this.shouldRenderToScreen) {
            g.drawImage(this.sBufferedImage, 0, 0, this);
        }
    }

    public void paintComponent(Graphics g) {
        this.paintProcess = 1;
        if (GraphicalObjectLib.isAnimating()) {
            this.graphics.setRenderQuality(28);
        } else if (this.currentStk != null) {
            this.graphics.setRenderQuality(27);
        } else {
            this.graphics.setRenderQuality(25);
        }
        this.graphics.setGraphics((Graphics2D)g, this.keepJavaAntialiasing);
        this.graphics.setIssuer("sheet");
        this.paintComponentBackground(this.graphics);
        this.graphics.pushStyle(this.gobs.getStyleRef());
        this.graphics.pushTransform(this.gobs.getTransformRef());
        this.gobs.render(this.graphics);
        if (this.currentStk != null && this.flagDrawCurrent && this.currentStk.getNumPoints() > 0) {
            Style currentStyle;
            if (this.currentStk.isRightButton()) {
                AffineTransform tx = this.getTransformRef();
                double scale = AffineTransformLib.getScaleFactor(tx);
                currentStyle = (Style)this.rightStyle.clone();
                currentStyle.setLineWidth((float)Math.max((double)this.rightLineWidth / scale, 1.0));
            } else {
                currentStyle = (Style)this.leftStyle.clone();
                currentStyle.setLineWidth(this.leftLineWidth);
            }
            this.graphics.pushStyle(this.currentStk.getStyleRef());
            this.graphics.pushStyle(currentStyle);
            this.graphics.pushTransform(this.currentStk.getTransformRef());
            this.currentStk.render(this.graphics);
            this.graphics.popTransform();
            this.graphics.popStyle();
            this.graphics.popStyle();
        }
        this.graphics.popTransform();
        this.graphics.popStyle();
        this.paintProcess = 2;
    }

    public boolean isPaintFinished() {
        if (this.paintProcess == 2) {
            this.paintProcess = 0;
            return true;
        }
        return false;
    }

    protected void paintComponentBackground(SatinGraphics graphics) {
        graphics.setBackground(this.getBackground());
        graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setTransparency(1.0f);
    }

    public String toString() {
        return String.valueOf(super.toString()) + "\n" + "\n" + this.gobs.toDebugString() + "\nAdd Filter:\n" + StringLib.indent(this.addFilter.toString(), 3) + "\nDraw Filter:\n" + StringLib.indent(this.drawFilter.toString(), 3) + "\n" + SatinConstants.cmdsubsys.toString();
    }

    public void addCommandToSheet(String cmdInXML) {
        System.out.println("Write ya own xml to command method!");
        System.out.println("I'm not doing anything with " + cmdInXML);
    }

    public void setGlobalID(String host, int id) {
        this.globalID = new GlobalID(host, id);
    }

    public void setGlobalID(GlobalID guid) {
        this.globalID = guid;
    }

    public GlobalID getGlobalID() {
        return this.globalID;
    }

    public String getGlobalIDXML() {
        return this.globalID.toXML();
    }

    public Object clone() {
        throw new RuntimeException("Clone not implemented for Sheet");
    }

    public Object deepClone() {
        throw new RuntimeException("Clone not implemented for Sheet");
    }

    public class SheetGraphicalObjectGroup
    extends GraphicalObjectGroupImpl {
        public SheetGraphicalObjectGroup() {
            super.addWatcher(Sheet.this);
        }

        public void disableDamage() {
            if (Sheet.this != null) {
                Sheet.this.disableDamage();
            }
        }

        public void enableDamage() {
            if (Sheet.this != null) {
                Sheet.this.enableDamage();
            }
        }

        public boolean hasDamageEnabled() {
            if (Sheet.this != null) {
                return Sheet.this.hasDamageEnabled();
            }
            return true;
        }

        public void damage(int sync) {
            Sheet.this.damage(sync);
        }

        public void damage(int sync, GraphicalObject gob) {
            Sheet.this.damage(sync, gob);
        }

        public void damage(int sync, Rectangle2D rect) {
            Sheet.this.damage(sync, rect);
        }

        public void damage(int sync, Rectangle2D oldRect, Rectangle2D newRect) {
            Sheet.this.damage(sync, oldRect, newRect);
        }

        public void superNotify(Watchable w, Object arg) {
            super.onNotify(w, arg);
        }

        public void superUpdate(Watchable w, Object arg) {
            super.onUpdate(w, arg);
        }

        public void superUpdate(Watchable w, String strProperty, Object oldVal, Object newVal) {
            super.onUpdate(w, strProperty, oldVal, newVal);
        }

        public void superDelete(Watchable w) {
            super.onDelete(w);
        }

        public void onNotify(Watchable w, Object arg) {
            Sheet.this.onNotify(w, arg);
        }

        public void onUpdate(Watchable w, Object arg) {
            Sheet.this.onUpdate(w, arg);
        }

        public void onUpdate(Watchable w, String strProperty, Object oldVal, Object newVal) {
            Sheet.this.onUpdate(w, strProperty, oldVal, newVal);
        }

        public void onDelete(Watchable w) {
            Sheet.this.onDelete(w);
        }

        public void preProcessNewStroke(NewStrokeEvent evt) {
            Sheet.this.preProcessNewStroke(evt);
        }

        public void superPreProcessNewStroke(NewStrokeEvent evt) {
            super.preProcessNewStroke(evt);
        }

        public void redispatchNewStroke(NewStrokeEvent evt) {
            Sheet.this.redispatchNewStroke(evt);
        }

        public void superRedispatchNewStroke(NewStrokeEvent evt) {
            super.redispatchNewStroke(evt);
        }

        public void postProcessNewStroke(NewStrokeEvent evt) {
            Sheet.this.postProcessNewStroke(evt);
        }

        public void superPostProcessNewStroke(NewStrokeEvent evt) {
            super.postProcessNewStroke(evt);
        }

        public void handleNewStroke(NewStrokeEvent evt) {
            Sheet.this.handleNewStroke(evt);
        }

        public void superHandleNewStroke(NewStrokeEvent evt) {
            super.handleNewStroke(evt);
        }

        public void preProcessUpdateStroke(UpdateStrokeEvent evt) {
            Sheet.this.preProcessUpdateStroke(evt);
        }

        public void superPreProcessUpdateStroke(UpdateStrokeEvent evt) {
            super.preProcessUpdateStroke(evt);
        }

        public void redispatchUpdateStroke(UpdateStrokeEvent evt) {
            Sheet.this.redispatchUpdateStroke(evt);
        }

        public void superRedispatchUpdateStroke(UpdateStrokeEvent evt) {
            super.redispatchUpdateStroke(evt);
        }

        public void postProcessUpdateStroke(UpdateStrokeEvent evt) {
            Sheet.this.postProcessUpdateStroke(evt);
        }

        public void superPostProcessUpdateStroke(UpdateStrokeEvent evt) {
            super.postProcessUpdateStroke(evt);
        }

        public void handleUpdateStroke(UpdateStrokeEvent evt) {
            Sheet.this.handleUpdateStroke(evt);
        }

        public void superHandleUpdateStroke(UpdateStrokeEvent evt) {
            super.handleUpdateStroke(evt);
        }

        public void preProcessSingleStroke(SingleStrokeEvent evt) {
            Sheet.this.preProcessSingleStroke(evt);
        }

        public void superPreProcessSingleStroke(SingleStrokeEvent evt) {
            super.preProcessSingleStroke(evt);
        }

        public void redispatchSingleStroke(SingleStrokeEvent evt) {
            Sheet.this.redispatchSingleStroke(evt);
        }

        public void superRedispatchSingleStroke(SingleStrokeEvent evt) {
            super.redispatchSingleStroke(evt);
        }

        public void postProcessSingleStroke(SingleStrokeEvent evt) {
            Sheet.this.postProcessSingleStroke(evt);
        }

        public void superPostProcessSingleStroke(SingleStrokeEvent evt) {
            super.postProcessSingleStroke(evt);
        }

        public void handleSingleStroke(SingleStrokeEvent evt) {
            Sheet.this.handleSingleStroke(evt);
        }

        public void superHandleSingleStroke(SingleStrokeEvent evt) {
            super.handleSingleStroke(evt);
        }

        public Sheet getSheet() {
            return Sheet.this;
        }

        public void setBoundingPoints2D(int cdsys, Shape s) {
        }

        public Rectangle2D getCollectionBounds2D(int cdsys) {
            return Sheet.this.getBounds();
        }

        public Rectangle2D getCollectionBounds2D(int cdsys, Rectangle2D rect) {
            if (rect == null) {
                rect = new Rectangle2D.Float();
            }
            rect.setRect(Sheet.this.getBounds());
            return rect;
        }

        protected void updateBoundingPoints() {
        }

        public Polygon2D getBoundingPoints2D(int cdsys) {
            return this.getBoundingPoints2D(cdsys, null, null);
        }

        public Polygon2D getBoundingPoints2D(int cdsys, AffineTransform tx, Polygon2D poly) {
            if (poly == null) {
                poly = new Polygon2D();
            }
            switch (cdsys) {
                case 10: {
                    poly.setToShape(this.getBounds2D(12));
                    break;
                }
                case 11: {
                    poly.setToShape(this.getBounds2D(12));
                    break;
                }
                case 12: {
                    poly.setToShape(this.getBounds2D(12));
                }
            }
            return poly;
        }

        public Rectangle2D getBounds2D(int cdsys) {
            return this.getBounds2D(cdsys, null, null);
        }

        public Rectangle2D getBounds2D(int cdsys, AffineTransform tx, Rectangle2D rect) {
            if (rect == null) {
                rect = new Rectangle2D.Float();
            }
            switch (cdsys) {
                case 10: {
                    Polygon2D p = this.getBoundingPoints2D(12);
                    p.transform(Sheet.this.getInverseTransform(11));
                    rect.setRect(p.getBounds2D());
                    break;
                }
                case 11: 
                case 12: {
                    rect.setRect(0.0, 0.0, Sheet.this.getWidth(), Sheet.this.getHeight());
                    break;
                }
                default: {
                    throw new RuntimeException("What the heck did you pass in?");
                }
            }
            return rect;
        }

        public boolean shapeContains(GraphicalObject gob) {
            return Sheet.this.shapeContains(gob);
        }

        public boolean shapeContains(int cdsys, Point2D pt) {
            return Sheet.this.shapeContains(cdsys, pt);
        }

        public boolean shapeContains(int cdsys, double x, double y) {
            return Sheet.this.shapeContains(cdsys, x, y);
        }

        public boolean shapeContains(int cdsys, Shape s) {
            return Sheet.this.shapeContains(cdsys, s);
        }

        public boolean shapeIntersects(GraphicalObject gob) {
            return Sheet.this.shapeIntersects(gob);
        }

        public boolean shapeIntersects(int cdsys, Shape s) {
            return Sheet.this.shapeIntersects(cdsys, s);
        }

        public boolean contains(double x, double y) {
            return Sheet.this.contains(x, y);
        }

        public boolean contains(double x, double y, double w, double h) {
            return Sheet.this.contains(x, y, w, h);
        }

        public boolean contains(Point2D p) {
            return Sheet.this.contains(p);
        }

        public boolean contains(Rectangle2D r) {
            return Sheet.this.contains(r);
        }

        public Rectangle2D getBounds2D() {
            return Sheet.this.getBounds2D();
        }

        public void setTransform(AffineTransform trans) {
            if (trans.getScaleX() == 0.0 || trans.getScaleY() == 0.0) {
                System.err.println("ERROR setTransform (AffineTransform): AffineTransform cannot have a 0 element on diagonal");
                trans = new AffineTransform(trans.getScaleX() != 0.0 ? trans.getScaleX() : 1.0, trans.getShearY(), trans.getShearX(), trans.getScaleY() != 0.0 ? trans.getScaleY() : 1.0, trans.getTranslateX(), trans.getTranslateY());
            }
            super.setTransform(trans);
        }

        public PathIterator getPathIterator(AffineTransform at) {
            return super.getPathIterator(at);
        }

        public PathIterator getPathIterator(AffineTransform at, double flatness) {
            return super.getPathIterator(at, flatness);
        }

        public boolean intersects(double x, double y, double w, double h) {
            return Sheet.this.intersects(x, y, w, h);
        }

        public boolean intersects(Rectangle2D r) {
            return Sheet.this.intersects(r);
        }
    }

    class InternalKeyListener
    extends KeyAdapter {
        InternalKeyListener() {
        }

        public void keyReleased(KeyEvent evt) {
            if (Sheet.this.GOBWithFocus != null && Sheet.this.GOBWithFocus instanceof GObJComponentWrapper) {
                ((GObJComponentWrapper)Sheet.this.GOBWithFocus).keyEventDispatcher(evt);
            }
        }

        public void keyTyped(KeyEvent evt) {
            if (Sheet.this.GOBWithFocus != null && Sheet.this.GOBWithFocus instanceof GObJComponentWrapper) {
                ((GObJComponentWrapper)Sheet.this.GOBWithFocus).keyEventDispatcher(evt);
            }
        }

        public void keyPressed(KeyEvent evt) {
            if (Sheet.this.GOBWithFocus != null) {
                if (Sheet.this.GOBWithFocus instanceof GObJComponentWrapper) {
                    ((GObJComponentWrapper)Sheet.this.GOBWithFocus).keyEventDispatcher(evt);
                }
            } else {
                int dx = 0;
                int dy = 0;
                int stepx = Sheet.this.getWidth() / 4;
                int stepy = Sheet.this.getHeight() / 4;
                switch (evt.getKeyCode()) {
                    case 68: {
                        if (!evt.isAltDown() || !evt.isControlDown()) break;
                        GraphicalObjectImpl.setClassDebugProperty(!GraphicalObjectImpl.getClassDebugProperty());
                        Sheet.this.damage(21);
                        break;
                    }
                    case 87: {
                        if (!evt.isAltDown() || !evt.isControlDown()) break;
                        Debug.setUseWindow(true);
                        break;
                    }
                    case 72: {
                        if (!evt.isAltDown() || !evt.isControlDown()) break;
                        SatinConstants.cmdqueue.dump();
                        break;
                    }
                    case 38: {
                        dy = -stepy;
                        break;
                    }
                    case 40: {
                        dy = stepy;
                        break;
                    }
                    case 37: {
                        dx = -stepx;
                        break;
                    }
                    case 39: {
                        dx = stepx;
                        break;
                    }
                    case 8: 
                    case 127: {
                        if (evt.isShiftDown()) {
                            Sheet.this.cutInternal();
                            break;
                        }
                        Sheet.this.deleteInternal();
                        break;
                    }
                    case 88: {
                        if (!evt.isControlDown() && !evt.isMetaDown()) break;
                        Sheet.this.cutInternal();
                        break;
                    }
                    case 67: {
                        if (!evt.isControlDown() && !evt.isMetaDown()) break;
                        Sheet.this.copyInternal();
                        break;
                    }
                    case 155: {
                        if (evt.isControlDown() || evt.isMetaDown()) {
                            Sheet.this.copyInternal();
                            break;
                        }
                        if (!evt.isShiftDown()) break;
                        Sheet.this.pasteInternal();
                        break;
                    }
                    case 86: {
                        if (!evt.isControlDown() && !evt.isMetaDown()) break;
                        Sheet.this.pasteInternal();
                        break;
                    }
                    case 89: {
                        if (!evt.isControlDown() && !evt.isMetaDown()) break;
                        Sheet.this.redoInternal();
                        break;
                    }
                    case 90: {
                        if (!evt.isControlDown() && !evt.isMetaDown()) break;
                        Sheet.this.undoInternal();
                    }
                }
                if (dx != 0 || dy != 0) {
                    int numFrm = 5;
                    AffineTransform tx = AffineTransform.getTranslateInstance(dx, dy);
                    AffineTransform[] txArray = AffineTransformLib.animateLinearly(tx, numFrm);
                    GraphicalObjectLib.animate(Sheet.this, txArray);
                }
            }
        }
    }

    class InternalMouseListener
    extends MouseAdapter {
        InternalMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            Sheet.this.setGobWithFocus(new Point(e.getX(), e.getY()));
        }

        public void mousePressed(MouseEvent evt) {
            Sheet.this.requestFocus();
        }

        public void mouseEntered(MouseEvent evt) {
            Sheet.this.setRepaintManager();
        }
    }

    public class DenimRepaintManager
    extends RepaintManager {
        public synchronized void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
            Container wrapper = c.getParent();
            if (wrapper == Sheet.this.swingWrapper && Sheet.this.GOBWithFocus != null) {
                if (((GraphicalObjectImpl)Sheet.this.GOBWithFocus).isRenderFinished()) {
                    Sheet.this.GOBWithFocus.damage(20);
                } else {
                    Sheet.this.GOBWithFocus.damage(22);
                }
            }
            super.addDirtyRegion(c, x, y, w, h);
        }
    }
}

