/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin;

import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.Sheet;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Vector;

public class RenderServer
extends Thread
implements SatinConstants {
    static long optimizedInterval = 1600L;
    private static int anticipationTime = 1300;
    private static final double beta = 0.1;
    private static final double base = -1.0 * Math.log(0.1);
    private static double alpha = base / (double)anticipationTime;
    private static final double step = alpha / 30.0;
    private static final double mergeEffectiveness = 0.3;
    boolean isStop = false;
    boolean isSuspended = false;
    Thread renderThread = null;
    Rectangle2D targetRect = null;
    boolean sceneGraphChanged = true;
    boolean realtimeRender = false;
    double flushSpeed = 1.0;
    long _flushTimeStamp = 0L;
    Sheet sheetInstance = null;
    private boolean needSerialFlush = false;
    private Vector serialBuffer = new Vector();
    RequestQueue _queue = new RequestQueue();

    public RenderServer(Sheet instance) {
        this.sheetInstance = instance;
    }

    public void adjustIdleAnticipation(boolean isIncrease) {
        int flag = isIncrease ? 1 : -1;
        double deltaAlpha = (double)flag * step * Math.random();
        anticipationTime = (int)(base / (alpha += deltaAlpha));
    }

    public void startSerialFlush() {
        this.needSerialFlush = true;
    }

    public void endSerialFlush() {
        this.needSerialFlush = false;
    }

    public void run() {
        if (this.sheetInstance != null) {
            while (!this.serialBuffer.isEmpty()) {
                Rectangle repaintRect = (Rectangle)this.serialBuffer.get(0);
                this.serialBuffer.remove(0);
                if (repaintRect != null) {
                    this.sceneGraphChanged = true;
                    this.sheetInstance.paintImmediately((int)repaintRect.getMinX(), (int)repaintRect.getMinY(), (int)repaintRect.getWidth(), (int)repaintRect.getHeight());
                    Toolkit.getDefaultToolkit().sync();
                }
                while (!this.sheetInstance.isPaintFinished()) {
                }
            }
            this.flush(20);
        }
    }

    private boolean evaluateEffectiveness(Rectangle2D src, Rectangle2D added) {
        Rectangle2D.Double merge = new Rectangle2D.Double();
        Rectangle2D.union(src, added, merge);
        double areaSum = src.getHeight() * src.getWidth() + added.getHeight() * added.getWidth();
        double areaMerge = ((RectangularShape)merge).getWidth() * ((RectangularShape)merge).getHeight();
        return areaSum / areaMerge >= 0.3;
    }

    public void startRealtimeRender() {
        this.realtimeRender = true;
        this.start();
    }

    public void setFlushSpeed(double p) {
        this.flushSpeed = p;
    }

    public double getFlushSpeed() {
        return this.flushSpeed;
    }

    public void endRealtimeRender() {
        this.realtimeRender = false;
        while (this._queue.size() > 0) {
            this.flush(this.flushSpeed);
        }
    }

    public boolean isSceneGraphChanged() {
        return this.sceneGraphChanged;
    }

    public void setSceneGraphChanged(boolean b) {
        this.sceneGraphChanged = b;
    }

    public void effectiveFlush(int sync) {
        Rectangle2D repaintRect = null;
        block0: while (this._queue.size() > 0) {
            repaintRect = this._queue.pullARequest();
            while (this._queue.size() > 0) {
                Rectangle2D r = this._queue.pullARequest();
                if (this.evaluateEffectiveness(repaintRect, r)) {
                    Rectangle2D.union(repaintRect, r, repaintRect);
                    continue;
                }
                this._queue.pushARequest(r);
                this.sceneGraphChanged = true;
                if (sync == 20) {
                    this.sheetInstance.paintImmediately((int)repaintRect.getMinX(), (int)repaintRect.getMinY(), (int)repaintRect.getWidth(), (int)repaintRect.getHeight());
                    continue block0;
                }
                this.sheetInstance.repaint((int)repaintRect.getMinX(), (int)repaintRect.getMinY(), (int)repaintRect.getWidth(), (int)repaintRect.getHeight());
                continue block0;
            }
        }
        if (repaintRect != null) {
            this.sceneGraphChanged = true;
            if (sync == 20) {
                this.sheetInstance.paintImmediately((int)repaintRect.getMinX(), (int)repaintRect.getMinY(), (int)repaintRect.getWidth(), (int)repaintRect.getHeight());
            } else {
                this.sheetInstance.repaint((int)repaintRect.getMinX(), (int)repaintRect.getMinY(), (int)repaintRect.getWidth(), (int)repaintRect.getHeight());
            }
        }
    }

    public long getLatestRenderTimeStamp() {
        return this._flushTimeStamp;
    }

    public void flush(double part) {
        if (this._queue.size() == 0) {
            return;
        }
        int num = (int)((double)this._queue.size() * part);
        if (num == 0) {
            num = 1;
        }
        Rectangle2D repaintRect = this._queue.pullARequest();
        Rectangle2D r = null;
        if (repaintRect != null && --num > 0) {
            r = this._queue.pullARequest();
            --num;
        }
        while (r != null && num > 0) {
            Rectangle2D.union(repaintRect, r, repaintRect);
            r = this._queue.pullARequest();
            --num;
        }
        if (repaintRect != null) {
            this.sceneGraphChanged = true;
            this.sheetInstance.repaint((int)repaintRect.getMinX(), (int)repaintRect.getMinY(), (int)repaintRect.getWidth(), (int)repaintRect.getHeight());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void flush(int sync) {
        Rectangle2D repaintRect = this._queue.pullARequest();
        Rectangle2D r = null;
        if (repaintRect == null) return;
        r = this._queue.pullARequest();
        while (r != null) {
            Rectangle2D.union(repaintRect, r, repaintRect);
            r = this._queue.pullARequest();
        }
        if (repaintRect == null) return;
        this.sceneGraphChanged = true;
        this._flushTimeStamp = System.currentTimeMillis();
        if (sync == 20) {
            this.sheetInstance.paintImmediately((int)repaintRect.getMinX(), (int)repaintRect.getMinY(), (int)repaintRect.getWidth(), (int)repaintRect.getHeight());
            return;
        } else {
            this.sheetInstance.repaint((int)repaintRect.getMinX(), (int)repaintRect.getMinY(), (int)repaintRect.getWidth(), (int)repaintRect.getHeight());
        }
    }

    public void sendARequest(Rectangle2D repaintRect, int sync) {
        if (this.needSerialFlush) {
            if (!this._queue.isEmpty()) {
                this.flush(21);
            }
            this.serialBuffer.add(repaintRect.clone());
            if (!this.isAlive()) {
                this.start();
            }
        } else {
            this._queue.pushARequest(repaintRect);
            if (this.realtimeRender) {
                this.flush(22);
            }
            if (sync == 20 || sync == 21) {
                this.flush(sync);
            } else if (sync != 22) {
                throw new RuntimeException("What the heck did you pass damage()?");
            }
        }
    }

    class RequestQueue
    extends Vector {
        RequestQueue() {
        }

        public synchronized void pushARequest(Rectangle2D r) {
            this.add(r.clone());
        }

        public synchronized Rectangle2D pullARequest() {
            if (this.size() > 0) {
                Rectangle2D r = (Rectangle2D)this.firstElement();
                this.remove(r);
                return r;
            }
            return null;
        }
    }
}

