/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.properties;

import edu.berkeley.guir.lib.properties.PropertyConstants;
import java.beans.PropertyVetoException;

public class PropertySchema
implements PropertyConstants {
    String strPropertyName = "UnnamedProperty";
    int propertyType = 5;

    public PropertySchema(String newPropertyName) {
        this.setPropertyName(newPropertyName);
    }

    public PropertySchema(String newPropertyName, int propertyType) {
        this.setPropertyName(newPropertyName);
        this.setPropertyType(propertyType);
    }

    public boolean acceptValue(Object oldVal, Object newVal) {
        return true;
    }

    public void onIllegalArgumentException(IllegalArgumentException e, Object oldVal, Object newVal) {
        System.err.println(e);
    }

    public void onPropertyVetoException(PropertyVetoException e, Object oldVal, Object newVal) {
        System.err.println(e);
    }

    public void setPropertyName(String newPropertyName) {
        this.strPropertyName = newPropertyName;
    }

    public String getPropertyName() {
        return this.strPropertyName;
    }

    public void setPropertyType(int type) {
        switch (type) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.propertyType = type;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid property type value");
            }
        }
    }

    public int getPropertyType() {
        return this.propertyType;
    }

    public void setSimpleProperty() {
        this.propertyType = 5;
    }

    public boolean isSimpleProperty() {
        return this.propertyType == 5;
    }

    public void setBoundProperty() {
        this.propertyType = 6;
    }

    public boolean isBoundProperty() {
        return this.propertyType == 6;
    }

    public void setConstrainedProperty() {
        this.propertyType = 7;
    }

    public boolean isConstrainedProperty() {
        return this.propertyType == 7;
    }

    public void setIndexedProperty() {
        this.propertyType = 8;
    }

    public boolean isIndexedProperty() {
        return this.propertyType == 8;
    }

    private static String toString(int propertyType) {
        switch (propertyType) {
            case 5: {
                return "Simple";
            }
            case 6: {
                return "Bound";
            }
            case 7: {
                return "Constrained";
            }
            case 8: {
                return "Indexed";
            }
        }
        throw new IllegalArgumentException("Invalid property type value");
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("[Type: " + PropertySchema.toString(this.propertyType) + "] ");
        strbuf.append("[Name: " + this.strPropertyName + "]");
        return strbuf.toString();
    }
}

