/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.properties;

import edu.berkeley.guir.lib.collection.HashBag;
import edu.berkeley.guir.lib.properties.EventListeners;
import edu.berkeley.guir.lib.properties.PropertyConstants;
import edu.berkeley.guir.lib.properties.PropertySchema;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FlexProperties
implements PropertyConstants {
    Object src;
    boolean flagSpecifiedOnly = false;
    int defaultPropertyType = 5;
    EventListeners evtlstnrs = new EventListeners();
    HashBag bagEnabled = new HashBag();
    int enabledCount = 0;
    HashMap mapSchema = new HashMap();
    HashMap mapProperties = new HashMap();

    public FlexProperties() {
        this.setSourceObject(this);
    }

    public FlexProperties(Object src) {
        this.setSourceObject(src);
    }

    public FlexProperties(Object src, boolean flag) {
        this.setSourceObject(src);
        this.setSpecifiedOnly(flag);
    }

    public void setSourceObject(Object obj) {
        this.src = obj;
    }

    public void setSpecifiedOnly(boolean flag) {
        this.flagSpecifiedOnly = flag;
    }

    public void setDefaultPropertyType(int type) {
        switch (type) {
            case 5: 
            case 6: 
            case 7: {
                this.defaultPropertyType = type;
                break;
            }
            case 8: {
                throw new RuntimeException("Don't use PROPERTY_INDEXED in this case - see javadoc documentation");
            }
            default: {
                throw new RuntimeException("Invalid property type value");
            }
        }
    }

    public void addSchema(PropertySchema schema) {
        this.mapSchema.put(schema.getPropertyName(), schema);
    }

    public PropertySchema removeSchema(PropertySchema schema) {
        return (PropertySchema)this.mapSchema.remove(schema.getPropertyName());
    }

    public PropertySchema getSchema(String strPropertyName) {
        return (PropertySchema)this.mapSchema.get(strPropertyName);
    }

    public boolean containsSchema(PropertySchema schema) {
        return this.mapSchema.containsKey(schema.getPropertyName());
    }

    public boolean containsSchema(String strPropertyName) {
        return this.mapSchema.containsKey(strPropertyName);
    }

    public void enableNotify() {
        if (this.enabledCount == 0) {
            throw new RuntimeException("Error - unbalanced number of disable / enable notify calls made");
        }
        --this.enabledCount;
    }

    public void enableNotify(String strProperty) {
        if (this.bagEnabled.size(strProperty) == 0) {
            throw new RuntimeException("Error - unbalanced number of disable / enable notify calls made on" + strProperty);
        }
        this.bagEnabled.remove(strProperty);
    }

    public boolean isEnabled() {
        return this.enabledCount <= 0;
    }

    public boolean isEnabled(String strProperty) {
        return this.enabledCount <= 0 && this.bagEnabled.size(strProperty) <= 0;
    }

    public void disableNotify() {
        ++this.enabledCount;
    }

    public void disableNotify(String strProperty) {
        this.bagEnabled.add(strProperty);
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        if (this.isEnabled(evt.getPropertyName())) {
            this.evtlstnrs.firePropertyChange(evt);
        }
    }

    public void firePropertyChange(String str, boolean oldVal, boolean newVal) {
        if (this.isEnabled(str)) {
            this.evtlstnrs.firePropertyChange(this.src, str, oldVal, newVal);
        }
    }

    public void firePropertyChange(String str, int oldVal, int newVal) {
        if (this.isEnabled(str)) {
            this.evtlstnrs.firePropertyChange(this.src, str, oldVal, newVal);
        }
    }

    public void firePropertyChange(String str, Object oldVal, Object newVal) {
        if (this.isEnabled(str)) {
            this.evtlstnrs.firePropertyChange(this.src, str, oldVal, newVal);
        }
    }

    public void fireVetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (this.isEnabled(evt.getPropertyName())) {
            this.evtlstnrs.fireVetoableChange(evt);
        }
    }

    public void fireVetoableChange(String str, boolean oldVal, boolean newVal) throws PropertyVetoException {
        if (this.isEnabled(str)) {
            this.evtlstnrs.fireVetoableChange(this.src, str, oldVal, newVal);
        }
    }

    public void fireVetoableChange(String str, int oldVal, int newVal) throws PropertyVetoException {
        if (this.isEnabled(str)) {
            this.evtlstnrs.fireVetoableChange(this.src, str, oldVal, newVal);
        }
    }

    public void fireVetoableChange(String str, Object oldVal, Object newVal) throws PropertyVetoException {
        if (this.isEnabled(str)) {
            this.evtlstnrs.fireVetoableChange(this.src, str, oldVal, newVal);
        }
    }

    public Iterator getPropertyNames() {
        return this.mapProperties.keySet().iterator();
    }

    private PropertySchema doPropertyCheck(String strPropertyName, boolean flagIndexed) {
        PropertySchema schema = this.getSchema(strPropertyName);
        if (schema != null) {
            if (schema.isIndexedProperty() != flagIndexed) {
                if (schema.isIndexedProperty()) {
                    throw new RuntimeException("Non-indexed access on an indexed property - " + strPropertyName);
                }
                throw new RuntimeException("Indexed access on a non-indexed property - " + strPropertyName);
            }
        } else if (this.flagSpecifiedOnly) {
            throw new RuntimeException("Specified property not registered in schema - " + strPropertyName);
        }
        return schema;
    }

    private void setPropertyRegression(boolean flagRemove, String strPropertyName, Object newVal) {
        PropertySchema schema = this.doPropertyCheck(strPropertyName, false);
        if (schema == null) {
            schema = new PropertySchema(strPropertyName, this.defaultPropertyType);
            this.addSchema(schema);
        }
        Object oldVal = this.mapProperties.get(strPropertyName);
        try {
            if (!schema.acceptValue(oldVal, newVal)) {
                throw new IllegalArgumentException("Invalid val for this property");
            }
            if (schema.isConstrainedProperty()) {
                this.fireVetoableChange(strPropertyName, oldVal, newVal);
            }
            if (flagRemove) {
                this.mapProperties.remove(strPropertyName);
            } else {
                this.mapProperties.put(strPropertyName, newVal);
            }
            if (schema.isConstrainedProperty() || schema.isBoundProperty()) {
                this.firePropertyChange(strPropertyName, oldVal, newVal);
            }
        }
        catch (IllegalArgumentException e) {
            schema.onIllegalArgumentException(e, oldVal, newVal);
        }
        catch (PropertyVetoException e) {
            schema.onPropertyVetoException(e, oldVal, newVal);
        }
    }

    public Object getProperty(String strPropertyName) {
        this.doPropertyCheck(strPropertyName, false);
        return this.mapProperties.get(strPropertyName);
    }

    public void setProperty(String strPropertyName, Object newVal) {
        this.setPropertyRegression(false, strPropertyName, newVal);
    }

    public Object removeProperty(String strPropertyName) {
        Object oldVal = this.mapProperties.get(strPropertyName);
        if (oldVal != null) {
            this.setPropertyRegression(true, strPropertyName, null);
        }
        return oldVal;
    }

    private LinkedList getList(String strPropertyName, boolean flagOpAllowNewSchema) {
        LinkedList list;
        PropertySchema schema = this.doPropertyCheck(strPropertyName, true);
        if (schema == null) {
            if (this.flagSpecifiedOnly) {
                throw new RuntimeException("Specified property not registered in schema - " + strPropertyName);
            }
            if (flagOpAllowNewSchema) {
                schema = new PropertySchema(strPropertyName, 8);
                this.addSchema(schema);
            } else {
                return null;
            }
        }
        if ((list = (LinkedList)this.mapProperties.get(strPropertyName)) == null) {
            list = new LinkedList();
            this.mapProperties.put(strPropertyName, list);
        }
        return list;
    }

    public List getIndexedProperty(String strPropertyName) {
        return this.getList(strPropertyName, false);
    }

    public Object getIndexedProperty(String strPropertyName, int index) {
        return this.getList(strPropertyName, false).get(index);
    }

    public void setIndexedProperty(String strPropertyName, int index, Object newVal) {
        this.getList(strPropertyName, true).set(index, newVal);
    }

    public void addIndexedProperty(String strPropertyName, Object newVal) {
        this.getList(strPropertyName, true).add(newVal);
    }

    public Object removeIndexedProperty(String strPropertyName, int index) {
        return this.getList(strPropertyName, false).remove(index);
    }

    public List removeIndexedProperty(String strPropertyName) {
        LinkedList list = this.getList(strPropertyName, false);
        this.mapProperties.remove(strPropertyName);
        return list;
    }

    public void clearIndexedProperty(String strPropertyName) {
        LinkedList list = this.getList(strPropertyName, false);
        if (list != null) {
            list.clear();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.evtlstnrs.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String str, PropertyChangeListener l) {
        this.evtlstnrs.addPropertyChangeListener(str, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.evtlstnrs.removePropertyChangeListener(l);
    }

    public void removePropertyChangeListener(String str, PropertyChangeListener l) {
        this.evtlstnrs.removePropertyChangeListener(str, l);
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        this.evtlstnrs.addVetoableChangeListener(l);
    }

    public void addVetoableChangeListener(String str, VetoableChangeListener l) {
        this.evtlstnrs.addVetoableChangeListener(str, l);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        this.evtlstnrs.removeVetoableChangeListener(l);
    }

    public void removeVetoableChangeListener(String str, VetoableChangeListener l) {
        this.evtlstnrs.removeVetoableChangeListener(str, l);
    }

    public void load(Reader rdr) throws IOException {
        BufferedReader brdr = new BufferedReader(rdr);
        String strLine = null;
        while ((strLine = brdr.readLine()) != null) {
            if (strLine.startsWith("#")) continue;
            int index = strLine.indexOf(61);
            if (index <= 0) {
                throw new IOException("Error parsing line in properties file: " + strLine);
            }
            String strKey = strLine.substring(0, index).trim();
            String strVal = strLine.substring(index + 1).trim();
            System.out.println("key: " + strKey);
            System.out.println("val: " + strVal);
        }
    }

    public void store(Writer wtr) throws IOException {
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        Iterator it = this.mapSchema.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            PropertySchema s = this.getSchema((String)key);
            strbuf.append(s + " [Value: " + this.mapProperties.get(key) + "]\n");
        }
        return strbuf.toString();
    }

    private static void runTestAAA() throws Exception {
        FlexProperties props = new FlexProperties();
        props.setProperty("Name", "Myname");
        System.out.println(props);
        props.setDefaultPropertyType(6);
        props.setProperty("Occupation", "Myoccupation");
        System.out.println(props);
        props.setDefaultPropertyType(7);
        props.setProperty("Address", "Myaddress");
        System.out.println(props);
        props.addIndexedProperty("names", "lucky");
        props.addIndexedProperty("names", "buffy");
        System.out.println(props);
        System.out.println("-----");
        props.setDefaultPropertyType(5);
        props.getProperty("aaa");
        props.setDefaultPropertyType(6);
        props.getProperty("bbb");
        props.setDefaultPropertyType(7);
        props.getProperty("ccc");
        System.out.println(props);
        System.out.println("-----");
        props.getIndexedProperty("ddd");
        props.clearIndexedProperty("eee");
        props.removeIndexedProperty("eee");
        System.out.println(props);
    }

    public static void runTestBBB() throws Exception {
        Object src = new Object();
        FlexProperties props = new FlexProperties(src);
        props.addPropertyChangeListener("dog_t", new RegressionPropertyChangeListener("dog"));
        props.addPropertyChangeListener("cat_t", new RegressionPropertyChangeListener("cat"));
        props.addPropertyChangeListener(new RegressionPropertyChangeListener("all"));
        PropertySchema s = new PropertySchema("dog_t");
        s.setConstrainedProperty();
        props.addSchema(s);
        s = new PropertySchema("cat_t");
        s.setConstrainedProperty();
        props.addSchema(s);
        props.setProperty("dog_t", "labrador");
        props.setProperty("cat_t", "meowth");
        System.out.println(props);
        System.out.println();
        System.out.println();
        props.disableNotify();
        props.setProperty("dog_t", "arcanine");
        props.setProperty("cat_t", "persian");
        System.out.println(props);
        props.enableNotify();
        props.disableNotify("dog_t");
        props.setProperty("dog_t", "dogval");
        props.setProperty("cat_t", "catval");
        System.out.println(props);
    }

    public static void runTestCCC() throws Exception {
        Object src = new Object();
        FlexProperties props = new FlexProperties(src);
        props.addPropertyChangeListener(new RegressionPropertyChangeListener());
        props.addVetoableChangeListener(new RegressionVetoableChangeListener());
        PropertySchema s = new PropertySchema("dog_t");
        s.setConstrainedProperty();
        props.addSchema(s);
        props.setProperty("dog_t", "labrador");
        props.setProperty("dog_t", "retriever");
        System.out.println(props);
        props.addIndexedProperty("names", "lucky");
        props.addIndexedProperty("names", "buffy");
        System.out.println(props);
        System.out.println(props.getIndexedProperty("names"));
        props.setIndexedProperty("names", 1, "fido");
        System.out.println(props.getIndexedProperty("names"));
        System.out.println(props.getIndexedProperty("names", 3));
    }

    public static void runTestDDD() throws Exception {
        FlexProperties p = new FlexProperties();
        p.load(new FileReader("out.txt"));
    }

    public static void main(String[] argv) throws Exception {
        FlexProperties.runTestAAA();
        FlexProperties.runTestBBB();
        FlexProperties.runTestCCC();
    }

    private static class RegressionPropertyChangeListener
    implements PropertyChangeListener {
        String str = "";

        public RegressionPropertyChangeListener() {
        }

        public RegressionPropertyChangeListener(String newstr) {
            this.str = newstr;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            System.out.println(String.valueOf(this.str) + "Property Change");
            System.out.println("   " + evt.getPropertyName());
            System.out.println("   " + evt.getOldValue());
            System.out.println("   " + evt.getNewValue());
        }
    }

    private static class RegressionVetoableChangeListener
    implements VetoableChangeListener {
        String str = "";

        public RegressionVetoableChangeListener() {
        }

        public RegressionVetoableChangeListener(String newstr) {
            this.str = newstr;
        }

        public void vetoableChange(PropertyChangeEvent evt) {
            System.out.println(String.valueOf(this.str) + "Vetoable Change");
            System.out.println("   " + evt.getPropertyName());
            System.out.println("   " + evt.getOldValue());
            System.out.println("   " + evt.getNewValue());
        }
    }
}

