/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.properties;

import edu.berkeley.guir.lib.collection.WeakHashSet;
import edu.berkeley.guir.lib.properties.PropertyConstants;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class EventListeners
implements PropertyConstants {
    HashMap mapPropertyChangeListeners = new HashMap();
    LinkedList listPropertyChangeListeners = new LinkedList();
    HashMap mapVetoableChangeListeners = new HashMap();
    LinkedList listVetoableChangeListeners = new LinkedList();

    EventListeners() {
    }

    private void addListener(List list, EventListener l) {
        list.add(l);
    }

    public void addListener(Map map, String str, EventListener l) {
        Set setListeners = (Set)map.get(str);
        if (setListeners == null) {
            setListeners = new WeakHashSet();
            map.put(str, setListeners);
        }
        setListeners.add(l);
    }

    public void removeListener(List list, Map map, EventListener l) {
        list.remove(l);
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            Set setListeners = (Set)map.get(key);
            setListeners.remove(l);
        }
    }

    public void removeListener(Map map, String str, EventListener l) {
        Set setListeners = (Set)map.get(str);
        if (setListeners == null) {
            return;
        }
        setListeners.remove(l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listPropertyChangeListeners = new LinkedList();
        this.addListener(this.listPropertyChangeListeners, l);
    }

    public void addPropertyChangeListener(String str, PropertyChangeListener l) {
        this.addListener(this.mapPropertyChangeListeners, str, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.removeListener(this.listPropertyChangeListeners, this.mapPropertyChangeListeners, (EventListener)l);
    }

    public void removePropertyChangeListener(String str, PropertyChangeListener l) {
        this.removeListener(this.mapPropertyChangeListeners, str, (EventListener)l);
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        this.addListener(this.listVetoableChangeListeners, l);
    }

    public void addVetoableChangeListener(String str, VetoableChangeListener l) {
        this.addListener(this.mapVetoableChangeListeners, str, l);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        this.removeListener(this.listVetoableChangeListeners, this.mapVetoableChangeListeners, (EventListener)l);
    }

    public void removeVetoableChangeListener(String str, VetoableChangeListener l) {
        this.removeListener(this.mapVetoableChangeListeners, str, (EventListener)l);
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        PropertyChangeListener lstnr;
        Iterator it = this.listPropertyChangeListeners.iterator();
        while (it.hasNext()) {
            lstnr = (PropertyChangeListener)it.next();
            lstnr.propertyChange(evt);
        }
        Set setListeners = (Set)this.mapPropertyChangeListeners.get(evt.getPropertyName());
        if (setListeners != null) {
            it = setListeners.iterator();
            while (it.hasNext()) {
                lstnr = (PropertyChangeListener)it.next();
                lstnr.propertyChange(evt);
            }
        }
    }

    public void firePropertyChange(Object src, String str, boolean oldVal, boolean newVal) {
        this.firePropertyChange(src, str, new Boolean(oldVal), new Boolean(newVal));
    }

    public void firePropertyChange(Object src, String str, int oldVal, int newVal) {
        this.firePropertyChange(src, str, new Integer(oldVal), new Integer(newVal));
    }

    public void firePropertyChange(Object src, String str, Object oldVal, Object newVal) {
        this.firePropertyChange(new PropertyChangeEvent(src, str, oldVal, newVal));
    }

    public void fireVetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        VetoableChangeListener lstnr;
        Iterator it = this.listVetoableChangeListeners.iterator();
        while (it.hasNext()) {
            lstnr = (VetoableChangeListener)it.next();
            lstnr.vetoableChange(evt);
        }
        Set setListeners = (Set)this.mapVetoableChangeListeners.get(evt.getPropertyName());
        if (setListeners != null) {
            it = setListeners.iterator();
            while (it.hasNext()) {
                lstnr = (VetoableChangeListener)it.next();
                lstnr.vetoableChange(evt);
            }
        }
    }

    public void fireVetoableChange(Object src, String str, boolean oldVal, boolean newVal) throws PropertyVetoException {
        this.fireVetoableChange(src, str, new Boolean(oldVal), new Boolean(newVal));
    }

    public void fireVetoableChange(Object src, String str, int oldVal, int newVal) throws PropertyVetoException {
        this.fireVetoableChange(src, str, new Integer(oldVal), new Integer(newVal));
    }

    public void fireVetoableChange(Object src, String str, Object oldVal, Object newVal) throws PropertyVetoException {
        this.fireVetoableChange(new PropertyChangeEvent(src, str, oldVal, newVal));
    }
}

