/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.noise;

import java.util.Random;

public class NoiseLib {
    public static final int B = 256;
    public static final int BM = 255;
    public static final int N = 4096;
    public static final int NP = 12;
    public static final int NM = 4095;
    static int[] p = new int[514];
    static float[][] g3 = new float[514][3];
    static float[][] g2 = new float[514][2];
    static float[] g1 = new float[514];
    static boolean start = true;
    static Random rand = new Random();

    private NoiseLib() {
    }

    private static final float s_curve(float t) {
        return t * t * (3.0f - 2.0f * t);
    }

    private static final float lerp(float t, float a, float b) {
        return a + t * (b - a);
    }

    private static final int random() {
        return Math.abs(rand.nextInt());
    }

    private static void normalize2(float[] v) {
        float s = (float)Math.sqrt(v[0] * v[0] + v[1] * v[1]);
        v[0] = v[0] / s;
        v[1] = v[1] / s;
    }

    private static void normalize3(float[] v) {
        float s = (float)Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
        v[0] = v[0] / s;
        v[1] = v[1] / s;
        v[2] = v[2] / s;
    }

    public static void init() {
        int j;
        int i = 0;
        while (i < 256) {
            NoiseLib.p[i] = i;
            NoiseLib.g1[i] = (float)(NoiseLib.random() % 512 - 256) / 256.0f;
            j = 0;
            while (j < 2) {
                NoiseLib.g2[i][j] = (float)(NoiseLib.random() % 512 - 256) / 256.0f;
                ++j;
            }
            NoiseLib.normalize2(g2[i]);
            j = 0;
            while (j < 3) {
                NoiseLib.g3[i][j] = (float)(NoiseLib.random() % 512 - 256) / 256.0f;
                ++j;
            }
            NoiseLib.normalize3(g3[i]);
            ++i;
        }
        i = 255;
        while (i >= 0) {
            int k = p[i];
            j = NoiseLib.random() % 256;
            NoiseLib.p[i] = p[j];
            NoiseLib.p[j] = k;
            --i;
        }
        i = 0;
        while (i < 258) {
            NoiseLib.p[256 + i] = p[i];
            NoiseLib.g1[256 + i] = g1[i];
            j = 0;
            while (j < 2) {
                NoiseLib.g2[256 + i][j] = g2[i][j];
                ++j;
            }
            j = 0;
            while (j < 3) {
                NoiseLib.g3[256 + i][j] = g3[i][j];
                ++j;
            }
            ++i;
        }
    }

    public static double noise1(float x) {
        if (start) {
            start = false;
            NoiseLib.init();
        }
        float t = x + 4096.0f;
        int bx0 = (int)t & 0xFF;
        int bx1 = bx0 + 1 & 0xFF;
        float rx0 = t - (float)((int)t);
        float rx1 = rx0 - 1.0f;
        float sx = NoiseLib.s_curve(rx0);
        float u = rx0 * g1[p[bx0]];
        float v = rx1 * g1[p[bx1]];
        return NoiseLib.lerp(sx, u, v);
    }

    public static double noise2(float x, float y) {
        if (start) {
            start = false;
            NoiseLib.init();
        }
        float t = x + 4096.0f;
        int bx0 = (int)t & 0xFF;
        int bx1 = bx0 + 1 & 0xFF;
        float rx0 = t - (float)((int)t);
        float rx1 = rx0 - 1.0f;
        t = y + 4096.0f;
        int by0 = (int)t & 0xFF;
        int by1 = by0 + 1 & 0xFF;
        float ry0 = t - (float)((int)t);
        float ry1 = ry0 - 1.0f;
        int i = p[bx0];
        int j = p[bx1];
        int b00 = p[i + by0];
        int b10 = p[j + by0];
        int b01 = p[i + by1];
        int b11 = p[j + by1];
        float sx = NoiseLib.s_curve(rx0);
        float sy = NoiseLib.s_curve(ry0);
        float[] q = g2[b00];
        float u = rx0 * q[0] + ry0 * q[1];
        q = g2[b10];
        float v = rx1 * q[0] + ry0 * q[1];
        float a = NoiseLib.lerp(sx, u, v);
        q = g2[b01];
        u = rx0 * q[0] + ry1 * q[1];
        q = g2[b11];
        v = rx1 * q[0] + ry1 * q[1];
        float b = NoiseLib.lerp(sx, u, v);
        return NoiseLib.lerp(sy, a, b);
    }

    public float noise3(float x, float y, float z) {
        if (start) {
            start = false;
            NoiseLib.init();
        }
        float t = x + 4096.0f;
        int bx0 = (int)t & 0xFF;
        int bx1 = bx0 + 1 & 0xFF;
        float rx0 = t - (float)((int)t);
        float rx1 = rx0 - 1.0f;
        t = y + 4096.0f;
        int by0 = (int)t & 0xFF;
        int by1 = by0 + 1 & 0xFF;
        float ry0 = t - (float)((int)t);
        float ry1 = ry0 - 1.0f;
        t = z + 4096.0f;
        int bz0 = (int)t & 0xFF;
        int bz1 = bz0 + 1 & 0xFF;
        float rz0 = t - (float)((int)t);
        float rz1 = rz0 - 1.0f;
        int i = p[bx0];
        int j = p[bx1];
        int b00 = p[i + by0];
        int b10 = p[j + by0];
        int b01 = p[i + by1];
        int b11 = p[j + by1];
        t = NoiseLib.s_curve(rx0);
        float sy = NoiseLib.s_curve(ry0);
        float sz = NoiseLib.s_curve(rz0);
        float[] q = g3[b00 + bz0];
        float u = rx0 * q[0] + ry0 * q[1] + rz0 * q[2];
        q = g3[b10 + bz0];
        float v = rx1 * q[0] + ry0 * q[1] + rz0 * q[2];
        float a = NoiseLib.lerp(t, u, v);
        q = g3[b01 + bz0];
        u = rx0 * q[0] + ry1 * q[1] + rz1 * q[2];
        q = g3[b11 + bz0];
        v = rx1 * q[0] + ry1 * q[1] + rz1 * q[2];
        float b = NoiseLib.lerp(t, u, v);
        float c = NoiseLib.lerp(sy, a, b);
        q = g3[b00 + bz1];
        u = rx0 * q[0] + ry0 * q[1] + rz0 * q[2];
        q = g3[b10 + bz1];
        v = rx1 * q[0] + ry0 * q[1] + rz0 * q[2];
        a = NoiseLib.lerp(t, u, v);
        q = g3[b01 + bz1];
        u = rx0 * q[0] + ry1 * q[1] + rz1 * q[2];
        q = g3[b11 + bz1];
        v = rx1 * q[0] + ry1 * q[1] + rz1 * q[2];
        b = NoiseLib.lerp(t, u, v);
        float d = NoiseLib.lerp(sy, a, b);
        return NoiseLib.lerp(sz, c, d);
    }
}

