/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.net;

import edu.berkeley.guir.lib.io.IOLib;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class GenericServer {
    private static final boolean DEBUG = false;
    ServerSocket svr;
    Socket sock;
    int port;
    boolean flagRun = true;
    boolean flagAsBuffer = false;
    boolean flagAsLine = false;
    boolean flagAsReaderWriter = false;
    boolean flagAsInputOutputStream = false;
    boolean flagAcceptLocalhostOnly = false;
    ListenThread thread;
    boolean flagDaemon = false;
    static InetAddress[] localhosts = new InetAddress[0];
    static boolean flagInit = false;

    public GenericServer(int aPort) {
        this(aPort, false);
    }

    public GenericServer(int aPort, boolean newFlagDaemon) {
        this.port = aPort;
        this.flagDaemon = newFlagDaemon;
    }

    private static void init() {
        if (flagInit) {
            return;
        }
        flagInit = true;
        try {
            localhosts = InetAddress.getAllByName("localhost");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isLocal(InetAddress addr) {
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return true;
        }
        GenericServer.init();
        int i = 0;
        while (i < localhosts.length) {
            if (localhosts[i].equals(addr)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setAcceptLocalhostOnly() {
        this.flagAcceptLocalhostOnly = true;
    }

    public void setGetAsBuffer() {
        this.flagAsBuffer = true;
    }

    public void setGetAsLine() {
        this.flagAsLine = true;
    }

    public void setGetAsInputOutputStream() {
        this.flagAsInputOutputStream = true;
    }

    public void setGetAsReaderWriter() {
        this.flagAsReaderWriter = true;
    }

    protected void listen() throws IOException {
        this.svr = new ServerSocket(this.port);
        this.flagRun = true;
        while (this.flagRun) {
            try {
                InetAddress addr;
                this.sock = this.svr.accept();
                if (this.flagAcceptLocalhostOnly && !GenericServer.isLocal(addr = this.sock.getInetAddress())) {
                    this.sock.close();
                }
                if (!this.sock.isConnected()) continue;
                this.handleSocket(this.sock);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void start() throws IOException {
        this.start(true);
    }

    public void start(boolean flagSynchronous) throws IOException {
        if (!(this.flagAsBuffer || this.flagAsLine || this.flagAsReaderWriter || this.flagAsInputOutputStream)) {
            throw new IllegalArgumentException("Have to set how to handle output, ex. setGetAsLine()");
        }
        if (flagSynchronous) {
            this.listen();
        } else {
            this.thread = new ListenThread();
            this.thread.setDaemon(this.flagDaemon);
            this.thread.start();
        }
    }

    public void stop() throws IOException {
        this.flagRun = false;
        this.svr.close();
        this.thread.interrupt();
    }

    protected void handleSocket(Socket sock) throws IOException {
        InputStream istream = sock.getInputStream();
        OutputStream ostream = sock.getOutputStream();
        if (this.flagAsInputOutputStream) {
            this.handleAsInputOutputStream(istream, ostream);
            ostream.flush();
        } else if (this.flagAsReaderWriter) {
            InputStreamReader rdr = new InputStreamReader(istream);
            OutputStreamWriter wtr = new OutputStreamWriter(ostream);
            this.handleAsReaderWriter(rdr, wtr);
            ((Writer)wtr).flush();
        } else if (this.flagAsLine) {
            String strLine;
            InputStreamReader rdr = new InputStreamReader(istream);
            OutputStreamWriter wtr = new OutputStreamWriter(ostream);
            BufferedReader brdr = new BufferedReader(rdr);
            while ((strLine = brdr.readLine()) != null) {
                this.handleAsLine(strLine, wtr);
                ((Writer)wtr).flush();
            }
        } else if (this.flagAsBuffer) {
            OutputStreamWriter wtr = new OutputStreamWriter(ostream);
            this.handleAsBuffer(IOLib.readAll(istream), wtr);
            ((Writer)wtr).flush();
        }
    }

    protected void handleAsInputOutputStream(InputStream istream, OutputStream ostream) throws IOException {
    }

    protected void handleAsReaderWriter(Reader rdr, Writer wtr) throws IOException {
    }

    protected void handleAsLine(String strLine, Writer wtr) throws IOException {
    }

    protected void handleAsBuffer(StringBuffer strbuf, Writer wtr) throws IOException {
    }

    class ListenThread
    extends Thread {
        ListenThread() {
        }

        public void run() {
            try {
                GenericServer.this.listen();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

