/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.metrics;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;

public class CodeCounter {
    public static final String BEGIN_TOKEN = "{";
    public static final String END_TOKEN = "}";
    public static final String COMMENT_EOLN = "//";
    public static final String COMMENT_BEGIN = "/*";
    public static final String COMMENT_CONTINUE = "*";
    public static final String COMMENT_END = "*/";
    public static final String STATEMENT_END = ";";
    public static final int METHOD_DEPTH = 1;
    String strFileName;
    int iLinesOfComments = 0;
    int iLinesOfLogicalCode = 0;
    int iLinesOfPhysicalCode = 0;
    int iNumMethods = 0;
    boolean bInsideCommentBlock = false;
    int iTokenPairCount = 0;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.metrics.CodeCounter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static int countOccurrencesOfCharacter(char chSearch, String strLine) {
        int iNumOccurrences = 0;
        int iStartIndex = 0;
        iStartIndex = strLine.indexOf(chSearch, 0);
        while (iStartIndex != -1) {
            ++iNumOccurrences;
            iStartIndex = strLine.indexOf(chSearch, iStartIndex + 1);
        }
        return iNumOccurrences;
    }

    public static int countOccurrencesOfString(String strSearch, String strLine) {
        int iNumOccurrences = 0;
        int iStartIndex = 0;
        iStartIndex = strLine.indexOf(strSearch, 0);
        while (iStartIndex != -1) {
            ++iNumOccurrences;
            iStartIndex = strLine.indexOf(strSearch, iStartIndex + 1);
        }
        return iNumOccurrences;
    }

    public static String removeSubstring(char chFrom, char chTo, String strLine) {
        int iStartIndex = strLine.indexOf(chFrom);
        int iEndIndex = strLine.indexOf(chFrom, iStartIndex + 1);
        if (iStartIndex == -1 || iEndIndex == -1) {
            return strLine;
        }
        return String.valueOf(strLine.substring(0, iStartIndex)) + strLine.substring(iEndIndex + 1);
    }

    public CodeCounter(String strFileName) {
        try {
            FileInputStream fistream = new FileInputStream(strFileName);
            this.strFileName = strFileName;
            this.countLines(fistream);
        }
        catch (Exception e) {
            System.out.println("File " + strFileName + " not found!");
        }
    }

    public CodeCounter(File f) {
        try {
            FileInputStream fistream = new FileInputStream(f);
            this.strFileName = f.getName();
            this.countLines(fistream);
        }
        catch (Exception e) {
            System.out.println("File " + f + " not found!");
        }
    }

    public int getLinesOfComments() {
        return this.iLinesOfComments;
    }

    public int getLinesOfLogicalCode() {
        return this.iLinesOfLogicalCode;
    }

    public int getLinesOfPhysicalCode() {
        return this.iLinesOfPhysicalCode;
    }

    public int getNumMethods() {
        return this.iNumMethods;
    }

    private void countLines(InputStream istream) {
        InputStreamReader istreamRdr = new InputStreamReader(istream);
        BufferedReader bufRdr = new BufferedReader(istreamRdr);
        try {
            String strLine;
            while ((strLine = bufRdr.readLine()) != null) {
                if ((strLine = strLine.trim()).equals("")) continue;
                this.setCommentBlock(strLine);
                this.checkLineForComments(strLine);
                strLine = this.simplifyLine(strLine);
                this.checkMethod(strLine);
                this.checkLineForLogicalCode(strLine);
                this.checkLineForPhysicalCode(strLine);
            }
        }
        catch (IOException e) {
            System.out.println("Error reading file " + this.strFileName);
            this.iLinesOfComments = 0;
            this.iLinesOfLogicalCode = 0;
            this.iLinesOfPhysicalCode = 0;
            this.iNumMethods = 0;
        }
    }

    private boolean isComment(String strLine) {
        if (strLine.startsWith(COMMENT_EOLN)) {
            return true;
        }
        if (this.bInsideCommentBlock) {
            return true;
        }
        return strLine.startsWith(COMMENT_BEGIN);
    }

    private String simplifyLine(String strLine) {
        String strReturn = strLine;
        while (!(strLine = strReturn).equals(strReturn = CodeCounter.removeSubstring('\"', '\"', strLine))) {
        }
        int iIndex = strLine.indexOf(COMMENT_EOLN);
        if (iIndex != -1) {
            strReturn = strLine.substring(0, iIndex);
        }
        return strReturn;
    }

    private void setCommentBlock(String strLine) {
        if (!strLine.startsWith(COMMENT_EOLN)) {
            if (strLine.lastIndexOf(COMMENT_BEGIN) != -1) {
                this.bInsideCommentBlock = true;
            }
            if (strLine.lastIndexOf(COMMENT_END) != -1 && this.bInsideCommentBlock) {
                this.bInsideCommentBlock = false;
            }
        }
    }

    private void checkMethod(String strLine) {
        int iNumTokensChange = 0;
        if (!$assertionsDisabled && this.iTokenPairCount < 0) {
            throw new AssertionError();
        }
        if (!this.isComment(strLine)) {
            this.iTokenPairCount += CodeCounter.countOccurrencesOfString(BEGIN_TOKEN, strLine);
            iNumTokensChange = CodeCounter.countOccurrencesOfString(END_TOKEN, strLine);
            if (iNumTokensChange > 0) {
                this.iTokenPairCount -= iNumTokensChange;
                if (this.iTokenPairCount == 1) {
                    ++this.iNumMethods;
                }
            }
        }
    }

    private void checkLineForComments(String strLine) {
        if ((this.isComment(strLine) || strLine.indexOf(COMMENT_EOLN) != -1) && !strLine.endsWith(COMMENT_CONTINUE)) {
            ++this.iLinesOfComments;
        }
    }

    private void checkLineForLogicalCode(String strLine) {
        if (!this.isComment(strLine) && strLine.indexOf(STATEMENT_END) != -1) {
            ++this.iLinesOfLogicalCode;
        }
    }

    private void checkLineForPhysicalCode(String strLine) {
        ++this.iLinesOfPhysicalCode;
    }

    public String toString() {
        return "Source File:            " + this.strFileName + "\n" + "Lines of Logical Code:  " + this.getLinesOfLogicalCode() + "\n" + "Number of methods:      " + this.getNumMethods() + "\n" + "Lines of Comments:      " + this.getLinesOfComments() + "\n" + "Lines of Physical Code: " + this.getLinesOfPhysicalCode();
    }

    private static boolean isJavaFile(File f) {
        return f.getName().endsWith(".java");
    }

    public static List getAllJavaFiles(File fRoot) {
        LinkedList<File> listJavaFiles = new LinkedList<File>();
        LinkedList<File> listDirectories = new LinkedList<File>();
        listDirectories.add(fRoot);
        while (listDirectories.size() > 0) {
            File fDir = (File)listDirectories.remove(0);
            File[] fSubdirs = fDir.listFiles();
            int i = 0;
            while (i < fSubdirs.length) {
                if (CodeCounter.isJavaFile(fSubdirs[i])) {
                    listJavaFiles.add(fSubdirs[i]);
                } else if (fSubdirs[i].isDirectory()) {
                    listDirectories.add(fSubdirs[i]);
                }
                ++i;
            }
        }
        return listJavaFiles;
    }

    private static List handleFile(File f) {
        LinkedList<CodeCounter> list = new LinkedList<CodeCounter>();
        if (!f.exists()) {
            System.err.println(String.valueOf(f.toString()) + " does not exist");
        } else if (f.isFile()) {
            CodeCounter c = new CodeCounter(f);
            list.add(c);
        } else if (f.isDirectory()) {
            List listJavaFiles = CodeCounter.getAllJavaFiles(f);
            File[] fJavaFiles = listJavaFiles.toArray(new File[0]);
            int i = 0;
            while (i < fJavaFiles.length) {
                list.add(new CodeCounter(fJavaFiles[i]));
                ++i;
            }
        }
        return list;
    }

    public static void main(String[] argv) {
        int i;
        List listCodeCounters;
        CodeCounter[] countArr = null;
        int iSumLinesOfLogicalCode = 0;
        int iSumNumMethods = 0;
        int iSumLinesOfComments = 0;
        int iSumLinesOfPhysicalCode = 0;
        if (argv.length <= 0) {
            listCodeCounters = CodeCounter.handleFile(new File("."));
        } else {
            listCodeCounters = new LinkedList();
            i = 0;
            while (i < argv.length) {
                listCodeCounters.addAll(CodeCounter.handleFile(new File(argv[i])));
                ++i;
            }
        }
        countArr = listCodeCounters.toArray(new CodeCounter[0]);
        i = 0;
        while (i < countArr.length) {
            System.out.println(countArr[i]);
            System.out.println();
            iSumLinesOfLogicalCode += countArr[i].getLinesOfLogicalCode();
            iSumNumMethods += countArr[i].getNumMethods();
            iSumLinesOfComments += countArr[i].getLinesOfComments();
            iSumLinesOfPhysicalCode += countArr[i].getLinesOfPhysicalCode();
            ++i;
        }
        System.out.println("\nSUMMARY INFORMATION\n#source files:          " + countArr.length + "\n" + "Lines of Logical Code:  " + iSumLinesOfLogicalCode + "\n" + "Number of methods:      " + iSumNumMethods + "\n" + "Lines of Comments:      " + iSumLinesOfComments + "\n" + "Lines of Physical Code: " + iSumLinesOfPhysicalCode);
    }
}

