/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.io;

import java.io.PrintWriter;
import java.io.Reader;

public interface ReaderPoolListener {
    public static final ReaderPoolListener CONSOLE = new Console();

    public void onData(Reader var1);

    public static class Console
    implements ReaderPoolListener {
        char[] chArr = new char[2048];
        int charsRead = 0;
        PrintWriter pwtr = new PrintWriter(System.out);

        public synchronized void onData(Reader rdr) {
            try {
                while (rdr.ready()) {
                    this.charsRead = rdr.read(this.chArr);
                    this.pwtr.write(this.chArr, 0, this.charsRead);
                    this.pwtr.flush();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }
}

