/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.io;

import edu.berkeley.guir.lib.io.ReaderPoolListener;
import edu.berkeley.guir.lib.util.Pollable;
import edu.berkeley.guir.lib.util.PollingPool;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReaderPool {
    PollingPool pool = new PollingPool();
    Map mapReadersPollable = new HashMap();
    List listListeners = new LinkedList();
    List listListenersTmp = new LinkedList();

    public void addReader(Reader rdr) {
        PollableReader pr = new PollableReader(rdr);
        this.pool.add(pr);
        this.mapReadersPollable.put(rdr, pr);
    }

    public void removeReader(Reader rdr) {
        PollableReader pr = (PollableReader)this.mapReadersPollable.get(rdr);
        if (pr != null) {
            this.pool.remove(pr);
        }
    }

    public void clearReaders() {
        this.pool.clear();
    }

    public Iterator readers() {
        return this.pool.iterator();
    }

    public Set getReaders() {
        return this.pool.getPollables();
    }

    public void addReaderPoolListener(ReaderPoolListener l) {
        this.listListeners.add(l);
    }

    public void removeReaderPoolListener(ReaderPoolListener l) {
        this.listListeners.remove(l);
    }

    public void clearReaderPoolListeners() {
        this.listListeners.clear();
    }

    private void fireEvent(Reader rdr) {
        this.listListenersTmp.clear();
        this.listListenersTmp.addAll(this.listListeners);
        Iterator it = this.listListenersTmp.iterator();
        while (it.hasNext()) {
            ReaderPoolListener l = (ReaderPoolListener)it.next();
            l.onData(rdr);
        }
    }

    public static void main(String[] argv) throws Exception {
        ReaderPool p = new ReaderPool();
        p.addReaderPoolListener(ReaderPoolListener.CONSOLE);
        Thread.sleep(2000L);
        FileReader rAA = new FileReader("ReaderPool.java");
        FileReader rBB = new FileReader("ReaderPoolListener.java");
        p.addReader(rAA);
        Thread.sleep(2000L);
        p.addReader(rBB);
    }

    class PollableReader
    implements Pollable {
        Reader rdr;

        public PollableReader(Reader newRdr) {
            this.rdr = newRdr;
        }

        public boolean isReady() {
            try {
                return this.rdr.ready();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                return false;
            }
        }

        public void onReady() {
            ReaderPool.this.fireEvent(this.rdr);
        }
    }
}

