/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class IOLib {
    public static final FileFilter FILE_FILTER_EMPTY = new EmptyFileFilter();
    public static final FileFilter FILE_FILTER_XML = new XmlFileFilter();
    public static final FileFilter FILE_FILTER_DIR = new DirectoryFileFilter();
    public static final FileFilter FILE_FILTER_FILE = new FileFileFilter();
    public static final InputStream INPUTSTREAM_EMPTY = new EmptyInputStream();
    public static final OutputStream OUTPUTSTREAM_EMPTY = new EmptyOutputStream();
    public static final Reader READER_EMPTY = new EmptyReader();
    public static final Writer WRITER_EMPTY = new EmptyWriter();

    private IOLib() {
    }

    public static boolean doesContainString(String strBody, String strSearch) {
        return IOLib.doesContainStrings(strBody, new String[]{strSearch});
    }

    public static boolean doesContainString(String strBody, String strAA, String strBB) {
        return IOLib.doesContainStrings(strBody, new String[]{strAA, strBB});
    }

    public static boolean doesContainStrings(String strBody, String[] strArr) {
        int i = 0;
        while (i < strArr.length) {
            if (strBody.indexOf(strArr[i]) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static File[] sortFilesByDate(File[] files) {
        int i = 0;
        while (i < files.length) {
            int j = i + 1;
            while (j < files.length) {
                long iDate = files[i].lastModified();
                long jDate = files[j].lastModified();
                if (jDate > iDate) {
                    File tmp = files[i];
                    files[i] = files[j];
                    files[j] = tmp;
                }
                ++j;
            }
            ++i;
        }
        return files;
    }

    public static File[] getFilesWithExtension(File fDir, String strExtension) {
        return fDir.listFiles(new ExtensionFileFilter(strExtension));
    }

    public static File[] getFilesMatchingPattern(File fDir, String strPattern) {
        return fDir.listFiles(new PatternFileFilter(strPattern));
    }

    public static File[] getAllFiles(File fDir) {
        if (!fDir.isDirectory()) {
            return new File[0];
        }
        ArrayList<File> listFiles = new ArrayList<File>();
        File[] files = fDir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                listFiles.addAll(Arrays.asList(IOLib.getAllFiles(files[i])));
            } else {
                listFiles.add(files[i]);
            }
            ++i;
        }
        return listFiles.toArray(new File[0]);
    }

    public static boolean doesContainString(File f, String str) throws IOException {
        return IOLib.doesContainStrings(f, new String[]{str});
    }

    public static boolean doesContainString(File f, String strAA, String strBB) throws IOException {
        return IOLib.doesContainStrings(f, new String[]{strAA, strBB});
    }

    public static boolean doesContainStrings(File f, String[] strArr) throws IOException {
        StringBuffer strFile = IOLib.readAll(f);
        return IOLib.doesContainStrings(strFile.toString(), strArr);
    }

    public static StringBuffer read(File f, int len) throws IOException {
        return IOLib.read(new FileReader(f), len);
    }

    public static StringBuffer read(InputStream istream, int len) throws IOException {
        return IOLib.read(new InputStreamReader(istream), len);
    }

    public static StringBuffer read(Reader rdr, int len) throws IOException {
        int nread;
        char[] cbuf = new char[len];
        StringBuffer strbuf = new StringBuffer();
        if (!(rdr instanceof BufferedReader)) {
            rdr = new BufferedReader(rdr);
        }
        while ((nread = rdr.read(cbuf)) > 0) {
            strbuf.append(cbuf, 0, nread);
        }
        return strbuf;
    }

    public static StringBuffer readAll(File f) throws IOException {
        return IOLib.readAll((Reader)new FileReader(f), new StringBuffer());
    }

    public static StringBuffer readAll(File f, StringBuffer strbuf) throws IOException {
        return IOLib.readAll((Reader)new FileReader(f), strbuf);
    }

    public static StringBuffer readAll(InputStream istream) throws IOException {
        return IOLib.readAll((Reader)new InputStreamReader(istream), new StringBuffer());
    }

    public static StringBuffer readAll(InputStream istream, StringBuffer strbuf) throws IOException {
        return IOLib.readAll((Reader)new InputStreamReader(istream), strbuf);
    }

    public static StringBuffer readAll(Reader rdr) throws IOException {
        return IOLib.readAll(rdr, new StringBuffer());
    }

    public static StringBuffer readAll(Reader rdr, char chStop) throws IOException {
        return IOLib.readAll(rdr, new StringBuffer(), chStop);
    }

    public static StringBuffer readAll(Reader rdr, StringBuffer strbuf) throws IOException {
        int nread;
        char[] cbuf = new char[4096];
        if (!(rdr instanceof BufferedReader)) {
            rdr = new BufferedReader(rdr);
        }
        while ((nread = rdr.read(cbuf)) > 0) {
            strbuf.append(cbuf, 0, nread);
        }
        return strbuf;
    }

    public static StringBuffer readAll(Reader rdr, StringBuffer strbuf, char chStop) throws IOException {
        int nread;
        char[] cbuf = new char[4096];
        if (!(rdr instanceof BufferedReader)) {
            rdr = new BufferedReader(rdr);
        }
        while ((nread = rdr.read(cbuf)) > 0) {
            if (cbuf[nread - 1] == chStop) {
                strbuf.append(cbuf, 0, nread - 1);
                break;
            }
            strbuf.append(cbuf, 0, nread);
        }
        return strbuf;
    }

    public static byte[] readAllBytes(File f) throws IOException {
        return IOLib.readAllBytes(new FileInputStream(f));
    }

    public static byte[] readAllBytes(InputStream istream) throws IOException {
        int nread;
        ByteArrayOutputStream bostream = new ByteArrayOutputStream();
        byte[] bbuf = new byte[4096];
        if (!(istream instanceof BufferedInputStream)) {
            istream = new BufferedInputStream(istream);
        }
        while ((nread = istream.read(bbuf)) > 0) {
            bostream.write(bbuf, 0, nread);
        }
        return bostream.toByteArray();
    }

    public static String readLine(InputStream istream) throws IOException {
        int nread;
        byte[] buf = new byte[128];
        StringBuffer strbuf = null;
        while ((nread = IOLib.readLine(istream, buf, 0, buf.length)) > 0) {
            if (nread >= buf.length) {
                strbuf = new StringBuffer(new String(buf, 0, nread));
                continue;
            }
            if (strbuf == null) break;
            strbuf.append(new String(buf, 0, nread));
            break;
        }
        if (nread <= 0) {
            return null;
        }
        if (strbuf == null) {
            return new String(buf, 0, nread);
        }
        return strbuf.toString();
    }

    public static int readLine(InputStream istream, byte[] buf, int off, int len) throws IOException {
        int val;
        if (len <= 0) {
            return 0;
        }
        int count = 0;
        while ((val = istream.read()) != -1) {
            buf[off++] = (byte)val;
            if (val == 10 || ++count == len) break;
        }
        if (count > 0) {
            return count;
        }
        return -1;
    }

    private static InputStream createInputStream() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("GET /index.html HTTP/1.0\r\n");
        strbuf.append("header1: val1\r\n");
        strbuf.append("header2: val2\r\n");
        strbuf.append("header3: val3\r\n");
        strbuf.append("\r\n");
        strbuf.append("msg msg msg\r\n");
        strbuf.append("msg msg msg\r\n");
        strbuf.append("0123456789");
        strbuf.append("0123456789");
        strbuf.append("0123456789");
        strbuf.append("0123456789");
        strbuf.append("0123456789");
        strbuf.append("0123456789");
        strbuf.append("0123456789");
        strbuf.append("0123456789");
        strbuf.append("0123456789");
        strbuf.append("0123456789");
        strbuf.append("0123456789");
        strbuf.append("0123456789");
        strbuf.append("0123456789");
        strbuf.append("0123456789");
        strbuf.append("0123456789");
        strbuf.append("0123456789");
        strbuf.append("0123456789");
        strbuf.append("0123456789");
        strbuf.append("0123456789");
        strbuf.append("AAAAAAAAAA\r\n");
        strbuf.append("0123456789");
        strbuf.append("AAAAAAAAAA\r\n");
        char[] cbuf = strbuf.toString().toCharArray();
        byte[] bbuf = new byte[cbuf.length];
        int i = 0;
        while (i < cbuf.length) {
            bbuf[i] = (byte)cbuf[i];
            ++i;
        }
        ByteArrayInputStream istream = new ByteArrayInputStream(bbuf);
        return istream;
    }

    private static void runTestAAA() throws Exception {
        String str;
        InputStream istream = IOLib.createInputStream();
        while ((str = IOLib.readLine(istream)) != null) {
            System.out.print(str);
        }
    }

    private static void runTestBBB() {
        File[] files = IOLib.getAllFiles(new File(System.getProperty("user.dir")));
        int i = 0;
        while (i < files.length) {
            System.out.println(files[i]);
            ++i;
        }
    }

    public static void main(String[] argv) throws Exception {
        IOLib.runTestBBB();
    }

    public static class EmptyInputStream
    extends InputStream {
        public int available() {
            return 0;
        }

        public void close() {
        }

        public void mark(int readlimit) {
        }

        public boolean markSupported() {
            return false;
        }

        public int read() {
            return -1;
        }

        public int read(byte[] b) {
            return -1;
        }

        public int read(byte[] b, int off, int len) {
            return -1;
        }

        public void reset() {
        }

        public long skip(long n) {
            return 0L;
        }
    }

    public static class EmptyOutputStream
    extends OutputStream {
        public void close() {
        }

        public void flush() {
        }

        public void write(byte[] b) {
        }

        public void write(byte[] b, int off, int len) {
        }

        public void write(int b) {
        }
    }

    public static class EmptyReader
    extends Reader {
        public void close() {
        }

        public void mark(int readAheadLimit) {
        }

        public boolean markSupported() {
            return false;
        }

        public int read() {
            return -1;
        }

        public int read(char[] c) {
            return -1;
        }

        public int read(char[] c, int off, int len) {
            return -1;
        }

        public boolean ready() {
            return false;
        }

        public void reset() {
        }

        public long skip(long n) {
            return 0L;
        }
    }

    public static class EmptyWriter
    extends Writer {
        public void close() {
        }

        public void flush() {
        }

        public void write(char[] c) {
        }

        public void write(char[] c, int off, int len) {
        }

        public void write(int c) {
        }

        public void write(String str) {
        }

        public void write(String str, int off, int len) {
        }
    }

    public static abstract class MultiFileFilter
    implements FileFilter {
        List listFilters = new LinkedList();

        public MultiFileFilter() {
        }

        public MultiFileFilter(FileFilter filterAA) {
            this.addFilter(filterAA);
        }

        public MultiFileFilter(FileFilter filterAA, FileFilter filterBB) {
            this.addFilter(filterAA);
            this.addFilter(filterBB);
        }

        public MultiFileFilter(FileFilter filterAA, FileFilter filterBB, FileFilter filterCC) {
            this.addFilter(filterAA);
            this.addFilter(filterBB);
            this.addFilter(filterCC);
        }

        public MultiFileFilter(FileFilter filterAA, FileFilter filterBB, FileFilter filterCC, FileFilter filterDD) {
            this.addFilter(filterAA);
            this.addFilter(filterBB);
            this.addFilter(filterCC);
            this.addFilter(filterDD);
        }

        public void addFilter(FileFilter filter) {
            this.listFilters.add(filter);
        }

        public Iterator filters() {
            return this.listFilters.iterator();
        }
    }

    public static class AndFileFilter
    extends MultiFileFilter {
        public AndFileFilter() {
        }

        public AndFileFilter(FileFilter filterAA) {
            super(filterAA);
        }

        public AndFileFilter(FileFilter filterAA, FileFilter filterBB) {
            super(filterAA, filterBB);
        }

        public AndFileFilter(FileFilter filterAA, FileFilter filterBB, FileFilter filterCC) {
            super(filterAA, filterBB, filterCC);
        }

        public AndFileFilter(FileFilter filterAA, FileFilter filterBB, FileFilter filterCC, FileFilter filterDD) {
            super(filterAA, filterBB, filterCC, filterDD);
        }

        public boolean accept(File pathname) {
            Iterator it = this.filters();
            while (it.hasNext()) {
                FileFilter filter = (FileFilter)it.next();
                if (filter.accept(pathname)) continue;
                return false;
            }
            return true;
        }
    }

    public static class OrFileFilter
    extends MultiFileFilter {
        public OrFileFilter() {
        }

        public OrFileFilter(FileFilter filterAA) {
            super(filterAA);
        }

        public OrFileFilter(FileFilter filterAA, FileFilter filterBB) {
            super(filterAA, filterBB);
        }

        public OrFileFilter(FileFilter filterAA, FileFilter filterBB, FileFilter filterCC) {
            super(filterAA, filterBB, filterCC);
        }

        public OrFileFilter(FileFilter filterAA, FileFilter filterBB, FileFilter filterCC, FileFilter filterDD) {
            super(filterAA, filterBB, filterCC, filterDD);
        }

        public boolean accept(File pathname) {
            Iterator it = this.filters();
            while (it.hasNext()) {
                FileFilter filter = (FileFilter)it.next();
                if (!filter.accept(pathname)) continue;
                return true;
            }
            return false;
        }
    }

    public static class EmptyFileFilter
    implements FileFilter {
        public boolean accept(File pathname) {
            return true;
        }
    }

    public static class FileFileFilter
    implements FileFilter {
        public boolean accept(File pathname) {
            return !pathname.isDirectory();
        }
    }

    public static class DirectoryFileFilter
    implements FileFilter {
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }

    public static class ExtensionFileFilter
    implements FileFilter {
        String strExtension;

        public ExtensionFileFilter(String newExtension) {
            this.strExtension = newExtension.startsWith(".") ? newExtension : "." + newExtension;
        }

        public boolean accept(File pathname) {
            String strFileName = pathname.getName();
            return strFileName.endsWith(this.strExtension);
        }
    }

    public static class XmlFileFilter
    extends ExtensionFileFilter {
        public XmlFileFilter() {
            super(".xml");
        }
    }

    public static class PatternFileFilter
    implements FileFilter {
        String strPattern;

        public PatternFileFilter(String aPattern) {
            this.strPattern = aPattern;
        }

        public boolean accept(File pathname) {
            String strFileName = pathname.getName();
            return strFileName.matches(this.strPattern);
        }
    }

    public static class DateFileFilter
    implements FileFilter {
        long startTime;
        long endTime;

        public DateFileFilter(long aStartTime, long aEndTime) {
            this.startTime = aStartTime;
            this.endTime = aEndTime;
        }

        public boolean accept(File pathname) {
            long lastModified = pathname.lastModified();
            return this.startTime <= lastModified && lastModified <= this.endTime;
        }
    }
}

