/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.io;

import java.io.File;

public class FileLib {
    public static final String FILE_PROTOCOL = "file:////";
    public static final String SERIALIZED_EXT = ".ser";
    public static final String ZIP_EXT = ".zip";
    public static final String CLASS_EXT = ".class";
    private static final String DEFAULT_ROOT = "file";
    private static final String DEFAULT_EXT = "tmp";
    private static int iFileCount = 0;

    private FileLib() {
    }

    public static String fileNameToURL(String strName) {
        return FILE_PROTOCOL + strName;
    }

    public static String URLToFileName(String strName) {
        if (strName.startsWith(FILE_PROTOCOL)) {
            return strName.substring(FILE_PROTOCOL.length());
        }
        return strName;
    }

    public static String localNameToNetworkName(String strName) {
        return strName.replace(File.separatorChar, '/');
    }

    public static String networkNameToLocalName(String strName) {
        return strName.replace('/', File.separatorChar);
    }

    public static String addFileNameExtension(String strFileName, String strExtension) {
        if (!strFileName.endsWith(strExtension)) {
            return String.valueOf(strFileName) + "." + strExtension;
        }
        return strFileName;
    }

    public static String addFileNameExtension(File f, String strExtension) {
        return FileLib.addFileNameExtension(f.getAbsolutePath(), strExtension);
    }

    public static String getFileNameExtension(String strFileName) {
        int periodLocation = strFileName.lastIndexOf(46);
        if (periodLocation >= 0) {
            return strFileName.substring(periodLocation + 1);
        }
        return "";
    }

    public static String removeFileNameExtension(String strFileName) {
        int periodLocation = strFileName.lastIndexOf(46);
        if (periodLocation >= 0) {
            return strFileName.substring(0, periodLocation);
        }
        return "";
    }

    public static String getFilePath(String strFileName) {
        File file = new File(strFileName);
        String strPath = file.getAbsolutePath();
        return strPath.substring(0, strPath.length() - strFileName.length());
    }

    public static String localNameToZip(String strFileName) {
        return FileLib.localNameToNetworkName(strFileName);
    }

    public static String generateUniqueFileName() {
        return FileLib.generateUniqueFileName(DEFAULT_ROOT, DEFAULT_EXT);
    }

    public static String generateUniqueFileName(String strRoot, String strExt) {
        return FileLib.generateUniqueFileName("", strRoot, strExt);
    }

    public static synchronized String generateUniqueFileName(String strPath, String strRoot, String strExt) {
        boolean done = false;
        String strFileNameTemp = null;
        if (!(strPath = FileLib.networkNameToLocalName(strPath)).equals("") && !strPath.endsWith(File.separator)) {
            strPath = String.valueOf(strPath) + File.separator;
        }
        if (!strExt.equals("") && strExt.charAt(0) != '.') {
            strExt = "." + strExt;
        }
        File tempFile = new File(strPath);
        tempFile.mkdirs();
        while (!done) {
            strFileNameTemp = String.valueOf(strPath) + strRoot + iFileCount + strExt;
            tempFile = new File(strFileNameTemp);
            done = !tempFile.exists();
            ++iFileCount;
        }
        return strFileNameTemp;
    }

    public static String[] getFilesInCurrentDirectory() {
        String strCurrentDir = System.getProperty("user.dir");
        return FileLib.getFilesInDirectory(strCurrentDir);
    }

    public static String[] getFilesInDirectory(String strDir) {
        File fileCurrentDir = new File(strDir);
        String[] strFileNameArray = fileCurrentDir.list();
        if (strFileNameArray == null) {
            strFileNameArray = new String[]{};
        }
        return strFileNameArray;
    }

    public static String stripClassExtension(String strClassName) {
        if (strClassName.endsWith(CLASS_EXT)) {
            strClassName = strClassName.substring(0, strClassName.length() - 6);
        }
        return strClassName;
    }

    public static boolean hasClassExtension(String strClassName) {
        return strClassName.endsWith(CLASS_EXT);
    }

    public static String classNameToLocalSystem(String strClassName) {
        strClassName = FileLib.stripClassExtension(strClassName);
        strClassName = strClassName.replace('.', File.separatorChar);
        strClassName = String.valueOf(strClassName) + CLASS_EXT;
        return strClassName;
    }

    public static String getClassName(String strFullClassName) {
        String strTemp = FileLib.stripClassExtension(strFullClassName);
        int iLastPosPeriod = strTemp.lastIndexOf(46);
        String strReturn = strTemp.substring(iLastPosPeriod + 1);
        return strReturn;
    }

    public static String getPackageName(String strFullClassName) {
        int iLastPosPeriod = (strFullClassName = FileLib.stripClassExtension(strFullClassName)).lastIndexOf(46);
        if (iLastPosPeriod < 0) {
            return "";
        }
        String strReturn = strFullClassName.substring(0, iLastPosPeriod);
        return strReturn;
    }

    public static String getPackageDirectory(String strFullClassName) {
        String strPackageName = FileLib.getPackageName(strFullClassName);
        if (strPackageName.equals("")) {
            return "";
        }
        strPackageName = strPackageName.replace('.', File.separatorChar);
        strPackageName = String.valueOf(strPackageName) + File.separator;
        return strPackageName;
    }
}

