/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public class DatagramOutputStream
extends OutputStream {
    DatagramSocket sock;
    InetAddress dstAddr;
    int dstPort;

    public DatagramOutputStream(InetAddress dstAddr, int dstPort) throws SocketException {
        this(new DatagramSocket(), dstAddr, dstPort);
    }

    public DatagramOutputStream(DatagramSocket newSock, InetAddress dstAddr, int dstPort) {
        this.sock = newSock;
        this.dstAddr = dstAddr;
        this.dstPort = dstPort;
    }

    public void close() {
        this.sock.close();
    }

    public void flush() {
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        DatagramPacket packet = new DatagramPacket(b, off, len, this.dstAddr, this.dstPort);
        this.sock.send(packet);
    }

    public void write(int b) {
    }

    public static String generateString(int len) {
        StringBuffer strbuf = new StringBuffer();
        int i = 0;
        while (i < len) {
            strbuf.append("" + i % 10);
            ++i;
        }
        return strbuf.toString();
    }

    public static byte[] toByteArray(String str) throws IOException {
        ByteArrayOutputStream bostream = new ByteArrayOutputStream();
        OutputStreamWriter wtr = new OutputStreamWriter(bostream);
        wtr.write(str);
        wtr.flush();
        return bostream.toByteArray();
    }

    public static void write(String str, OutputStream ostream) throws IOException {
        byte[] bArr = DatagramOutputStream.toByteArray(str);
        System.out.println("string len:   " + str.length());
        System.out.println("byte arr len: " + bArr.length);
        ostream.write(bArr);
    }

    public static void main(String[] argv) throws Exception {
        DatagramOutputStream ostream = new DatagramOutputStream(InetAddress.getLocalHost(), 8080);
        DatagramOutputStream.write("dog", ostream);
        DatagramOutputStream.write("cat", ostream);
        DatagramOutputStream.write(DatagramOutputStream.generateString(2048), ostream);
        DatagramOutputStream.write(DatagramOutputStream.generateString(4096), ostream);
        DatagramOutputStream.write(DatagramOutputStream.generateString(8192), ostream);
    }
}

