/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DataBuffer {
    private static final int DEFAULT_SIZE = 8192;
    byte[] databuf;
    int datalen;

    public DataBuffer() {
        this(8192);
    }

    public DataBuffer(int len) {
        if (len <= 0) {
            throw new IllegalArgumentException("buffer size " + len + " should be positive");
        }
        this.databuf = new byte[len];
        this.datalen = 0;
    }

    public DataBuffer(byte[] buf) {
        this(buf, buf.length);
    }

    public DataBuffer(byte[] buf, int len) {
        if (len <= 0) {
            throw new IllegalArgumentException("buffer size " + len + " should be positive");
        }
        this.databuf = buf;
        this.datalen = len;
    }

    public DataBuffer(String str) {
        this(str.getBytes());
    }

    public DataBuffer(InputStream istream, int totallen) throws IOException {
        this.readAll(istream, totallen);
    }

    public DataBuffer(InputStream istream) throws IOException {
        this.readAll(istream);
    }

    public void readAll(InputStream istream) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        while ((len = istream.read(buf, 0, buf.length)) > 0) {
            this.append(buf);
        }
    }

    public void readAll(InputStream istream, int totallen) throws IOException {
        int len;
        byte[] buf = new byte[totallen];
        int runlen = 0;
        while ((len = istream.read(buf, 0, buf.length)) > 0) {
            this.append(buf);
            if ((runlen += len) < totallen) continue;
            return;
        }
    }

    public void writeAll(OutputStream ostream) throws IOException {
        ostream.write(this.databuf, 0, this.datalen);
    }

    public void writeToFile(String strFileName) throws IOException {
        this.saveToFile(strFileName, false);
    }

    public void appendToFile(String strFileName) throws IOException {
        this.saveToFile(strFileName, true);
    }

    private void saveToFile(String strFileName, boolean flagAppend) throws IOException {
        FileOutputStream fostream = new FileOutputStream(strFileName, flagAppend);
        BufferedOutputStream bostream = new BufferedOutputStream(fostream);
        bostream.write(this.databuf, 0, this.datalen);
        bostream.flush();
        bostream.close();
    }

    public void readFromFile(String strFileName) throws IOException, FileNotFoundException {
        File file = new File(strFileName);
        long fileLength = file.length();
        int length = fileLength > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)fileLength;
        this.resize(length);
        FileInputStream fistream = new FileInputStream(strFileName);
        this.datalen = length;
        fistream.read(this.databuf, 0, length);
        fistream.close();
    }

    public byte[] getBytes() {
        return this.databuf;
    }

    public int getLength() {
        return this.datalen;
    }

    public int indexOf(String str) {
        return this.indexOf(0, str.getBytes(), 0, str.length());
    }

    public int indexOf(int start, String str) {
        return this.indexOf(start, str.getBytes(), 0, str.length());
    }

    public int indexOf(int start, String str, int offset, int len) {
        return this.indexOf(start, str.getBytes(), offset, len);
    }

    public int index(DataBuffer searchbuf) {
        return this.indexOf(0, searchbuf.getBytes(), 0, searchbuf.getLength());
    }

    public int index(int start, DataBuffer searchbuf, int offset, int len) {
        return this.indexOf(start, searchbuf.getBytes(), offset, len);
    }

    public int indexOf(byte[] searchbuf) {
        return this.indexOf(0, searchbuf, 0, searchbuf.length);
    }

    public int indexOf(int start, byte[] searchbuf, int offset, int len) {
        int j = offset;
        for (int i = start; i < this.getLength(); ++i) {
            if (this.databuf[i] == searchbuf[j]) {
                ++j;
                continue;
            }
            j = offset;
            if (j < len) continue;
            return i - j;
        }
        return -1;
    }

    public int indexOf(int start, char ch) {
        int i = start;
        while (i < this.getLength()) {
            if (this.databuf[i] == (byte)ch) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(char ch) {
        return this.indexOf(0, ch);
    }

    public final byte at(int index) {
        if (index >= this.datalen) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.databuf[index];
    }

    public void replace(String[] strFindArray, String strReplace) {
        int i = 0;
        while (i < strFindArray.length) {
            this.replace(strFindArray[i], strReplace);
            ++i;
        }
    }

    public void replace(String strFind, String strReplace) {
        int index = this.indexOf(0, strFind);
        while (index >= 0) {
            index = this.replaceHelper(index, strFind, strReplace);
        }
    }

    private int replaceHelper(int startpos, String strFind, String strReplace) {
        int index = this.indexOf(startpos, strFind);
        if (index >= 0) {
            if (strFind.length() != strReplace.length()) {
                this.insert(index, strReplace);
                this.remove(index + strReplace.length(), strFind.length());
            } else {
                int i = 0;
                while (i < strReplace.length()) {
                    this.databuf[index + i] = (byte)strReplace.charAt(i);
                    ++i;
                }
            }
        }
        return index;
    }

    public void clear() {
        this.datalen = 0;
    }

    public void fill() {
        this.fill((byte)0);
    }

    public void fill(byte bb) {
        int i = 0;
        while (i < this.databuf.length) {
            this.databuf[i] = bb;
            ++i;
        }
    }

    public void resize(int size) {
        int newsize = this.databuf.length;
        while (newsize < size) {
            newsize *= 2;
        }
        byte[] newbuf = new byte[newsize];
        System.arraycopy(this.databuf, 0, newbuf, 0, this.datalen);
        this.databuf = newbuf;
    }

    public void compact() {
        this.resize(0);
    }

    public void append(byte[] insertbuf) {
        this.insert(this.datalen, insertbuf);
    }

    public void append(byte[] insertbuf, int off, int len) {
        this.insert(this.datalen, insertbuf, off, len);
    }

    public void append(DataBuffer buf) {
        this.insert(this.datalen, buf.getBytes(), 0, buf.getLength());
    }

    public void append(byte bb) {
        byte[] buf = new byte[]{bb};
        this.append(buf);
    }

    public void insert(int pos, int len) {
        byte[] newbuf = this.datalen + len > this.databuf.length ? new byte[this.datalen + len] : new byte[this.databuf.length];
        System.arraycopy(this.databuf, 0, newbuf, 0, pos);
        System.arraycopy(this.databuf, pos, newbuf, pos + len, this.datalen - pos);
        this.databuf = newbuf;
        this.datalen += len;
    }

    public void insert(int pos, byte[] insertbuf, int off, int len) {
        this.insert(pos, len);
        System.arraycopy(insertbuf, off, this.databuf, pos, len);
    }

    public void insert(int pos, String str) {
        this.insert(pos, str.getBytes(), 0, str.length());
    }

    public void insert(int pos, byte[] insertbuf) {
        this.insert(pos, insertbuf, 0, insertbuf.length);
    }

    public void insert(int pos, DataBuffer buf) {
        this.insert(pos, buf.getBytes(), 0, buf.getLength());
    }

    public void insert(int pos, DataBuffer buf, int off, int len) {
        this.insert(pos, buf.getBytes(), off, len);
    }

    public void remove(int pos, int len) {
        System.arraycopy(this.databuf, pos + len, this.databuf, pos, this.databuf.length - pos - len);
        this.datalen -= len;
    }

    public void setBytes(byte[] buf, int len) {
        this.databuf = buf;
        this.setLength(len);
    }

    public void copyBytes(byte[] buf, int len) {
        System.arraycopy(buf, 0, this.databuf, 0, len);
        this.setLength(len);
    }

    public void setLength(int len) {
        this.datalen = len;
    }

    public String toString() {
        return new String(this.databuf, 0, this.datalen);
    }
}

