/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.InputEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class awt {
    public static Window getWindow(Component c) {
        Window result = c == null ? null : (c instanceof Window ? (Window)c : SwingUtilities.windowForComponent(c));
        return result;
    }

    public static Dimension getTextSize(Component c, String s) {
        FontMetrics fm = c.getFontMetrics(c.getFont());
        return new Dimension(fm.stringWidth(s), fm.getMaxAscent() + fm.getMaxDescent());
    }

    public static Dimension sizeWithInsets(Graphics g, JComponent c) {
        Insets insets = c.getInsets();
        Dimension size = c.getSize();
        g.translate(insets.left, insets.top);
        size.width -= insets.left + insets.right;
        size.height -= insets.top + insets.bottom;
        g.clipRect(0, 0, size.width, size.height);
        return size;
    }

    public static int getChildIndex(Container container, Component child) {
        int numComponents = container.getComponentCount();
        int i = 0;
        while (i < numComponents) {
            if (container.getComponent(i).equals(child)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String eventModifiers(InputEvent e) {
        StringBuffer result = new StringBuffer("");
        if (e.isAltDown()) {
            result.append("A");
        }
        if (e.isAltGraphDown()) {
            result.append("G");
        }
        if (e.isControlDown()) {
            result.append("C");
        }
        if (e.isMetaDown()) {
            result.append("M");
        }
        if (e.isShiftDown()) {
            result.append("S");
        }
        return result.toString();
    }
}

